/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.hbncontainer;

import fi.csc.microarray.manager.web.ChipsterConfiguration;
import fi.csc.microarray.manager.web.data.JobLogEntry;
import fi.csc.microarray.util.Exceptions;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateUtil {
    private static final Logger logger;
    private static final SessionFactory sessionFactory;

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    static {
        String dbPassword;
        String dbUsername;
        String dbUrl;
        String dbDriver;
        fi.csc.microarray.config.Configuration chiptserConf;
        logger = LoggerFactory.getLogger(HibernateUtil.class);
        logger.debug("Initializing HibernateUtil");
        try {
            chiptserConf = ChipsterConfiguration.getConfiguration();
        }
        catch (Exception e) {
            System.err.println("Initialising Chipster configuration failed.\n" + Exceptions.getStackTrace(e));
            throw new ExceptionInInitializerError(e);
        }
        Configuration hibernateConf = new Configuration();
        try {
            dbDriver = chiptserConf.getString("manager", "jdbc-driver");
            dbUrl = chiptserConf.getString("manager", "database-url");
            dbUsername = chiptserConf.getString("manager", "database-username");
            dbPassword = chiptserConf.getString("manager", "database-password");
        }
        catch (Exception e) {
            dbDriver = "org.h2.Driver";
            dbUrl = "jdbc:h2:database/chipster-manager";
            dbUsername = "chipster";
            dbPassword = "";
            System.err.println("Chipster configuration unavailable, trying to use development database at " + dbUrl);
        }
        try {
            hibernateConf.setProperty("hibernate.connection.driver_class", dbDriver);
            hibernateConf.setProperty("hibernate.connection.url", dbUrl);
            hibernateConf.setProperty("hibernate.connection.username", dbUsername);
            hibernateConf.setProperty("hibernate.connection.password", dbPassword);
            hibernateConf.setProperty("hibernate.dialect", H2Dialect.class.getName());
            hibernateConf.setProperty("hibernate.show_sql", "true");
            hibernateConf.setProperty("hibernate.current_session_context_class", "thread");
            hibernateConf.addAnnotatedClass(JobLogEntry.class);
            ServiceRegistryBuilder serviceRegistryBuilder = new ServiceRegistryBuilder();
            ServiceRegistry serviceRegistry = serviceRegistryBuilder.applySettings((Map)hibernateConf.getProperties()).buildServiceRegistry();
            sessionFactory = hibernateConf.buildSessionFactory(serviceRegistry);
        }
        catch (Throwable ex) {
            System.err.println("Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);
        }
    }
}

