/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.data;

import fi.csc.microarray.manager.web.data.JobLogEntry;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

public class StatDataSource {
    public static final String ROW_COUNT = "count";

    public List<Map<Object, Object>> getTopUsers(Session session) {
        GregorianCalendar fromDate = new GregorianCalendar();
        fromDate.set(1, fromDate.get(1) - 1);
        LinkedList<HashMap<String, Object>> results = session.createCriteria(JobLogEntry.class).add((Criterion)Restrictions.ge((String)"startTime", (Object)fromDate.getTime())).setProjection((Projection)Projections.projectionList().add(Projections.rowCount(), ROW_COUNT).add((Projection)Projections.groupProperty((String)"username"), "username")).addOrder(Order.desc((String)ROW_COUNT)).setMaxResults(10).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
        if (results == null || results.size() == 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("username", null);
            map.put(ROW_COUNT, null);
            results = new LinkedList<HashMap<String, Object>>();
            results.add(map);
        }
        return this.typedMap((List<Map>)results);
    }

    public Object[] getTopUsersColumnOrder() {
        return new Object[]{"username", ROW_COUNT};
    }

    public List<JobLogEntry> getLatestJobs(Session session) {
        List results = session.createCriteria(JobLogEntry.class).addOrder(Order.desc((String)"startTime")).setMaxResults(10).list();
        return results;
    }

    public List<Map<Object, Object>> getJobsByMonth(Session session) {
        LinkedList<HashMap<String, Object>> results = session.createQuery("select new map(year(startTime) as year, month(startTime) as month, count(*) as count) from JobLogEntry group by year(startTime), month(startTime) order by year(startTime) asc, month(startTime) asc").list();
        if (results == null || results.size() == 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object[] cols = this.getJobsByMonthColumnOrder();
            map.put((String)cols[0], null);
            map.put((String)cols[1], null);
            map.put((String)cols[2], null);
            results = new LinkedList<HashMap<String, Object>>();
            results.add(map);
        }
        return this.typedMap((List<Map>)results);
    }

    public Object[] getJobsByMonthColumnOrder() {
        return new Object[]{"year", "month", ROW_COUNT};
    }

    public List<Map<Object, Object>> getToolFails(Session session) {
        GregorianCalendar fromDate = new GregorianCalendar();
        fromDate.set(1, fromDate.get(1) - 1);
        LinkedList<HashMap<String, Object>> results = session.createCriteria(JobLogEntry.class).add((Criterion)Restrictions.ge((String)"startTime", (Object)fromDate.getTime())).add((Criterion)Restrictions.eq((String)"status", (Object)"FAILED")).setProjection((Projection)Projections.projectionList().add(Projections.rowCount(), ROW_COUNT).add((Projection)Projections.groupProperty((String)"operation"), "operation")).addOrder(Order.desc((String)ROW_COUNT)).setMaxResults(10).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP).list();
        if (results == null || results.size() == 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("operation", null);
            map.put(ROW_COUNT, null);
            results = new LinkedList<HashMap<String, Object>>();
            results.add(map);
        }
        return this.typedMap((List<Map>)results);
    }

    public Object[] getToolFailsColumnOrder() {
        return new Object[]{"operation", ROW_COUNT};
    }

    private List<Map<Object, Object>> typedMap(List<Map> rawtype) {
        LinkedList<Map<Object, Object>> typed = new LinkedList<Map<Object, Object>>();
        for (Map rawItem : rawtype) {
            typed.add(rawItem);
        }
        return typed;
    }
}

