/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager.web.data;

import com.vaadin.data.util.BeanItemContainer;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.manager.web.ChipsterConfiguration;
import fi.csc.microarray.manager.web.data.ServiceEntry;
import fi.csc.microarray.manager.web.ui.ServicesView;
import fi.csc.microarray.messaging.AdminAPI;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import javax.jms.JMSException;

public class ServiceContainer
extends BeanItemContainer<ServiceEntry>
implements Serializable {
    public static final String NAME = "name";
    public static final String COUNT = "count";
    public static final String HOST = "host";
    public static final String STATUS = "status";
    public static final Object[] NATURAL_COL_ORDER = new String[]{"name", "host", "status"};
    public static final String[] COL_HEADERS_ENGLISH = new String[]{"Service name", "Host", "Status"};
    public static final String[] SERVER_NAMES = new String[]{"authenticator", "analyser", "filebroker", "manager"};

    public ServiceContainer() throws InstantiationException, IllegalAccessException {
        super(ServiceEntry.class);
    }

    public void update(final ServicesView view) {
        ExecutorService execService = Executors.newCachedThreadPool();
        execService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    NodeBase nodeSupport = new NodeBase(){

                        @Override
                        public String getName() {
                            return "chipster-admin-web";
                        }
                    };
                    ChipsterConfiguration.init();
                    MessagingEndpoint endpoint = new MessagingEndpoint(nodeSupport);
                    AdminAPI api = new AdminAPI(endpoint.createTopic(Topics.Name.ADMIN_TOPIC, MessagingTopic.AccessMode.READ), new AdminAPI.AdminAPILIstener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void statusUpdated(Map<String, AdminAPI.NodeStatus> statuses) {
                            Lock tableLock = view.getTable().getUI().getSession().getLock();
                            tableLock.lock();
                            try {
                                ServiceContainer.this.removeAllItems();
                                for (Map.Entry<String, AdminAPI.NodeStatus> entry : statuses.entrySet()) {
                                    String[] hosts;
                                    AdminAPI.NodeStatus node = entry.getValue();
                                    if (node.host == null) continue;
                                    for (String host : hosts = node.host.split(", ")) {
                                        ServiceEntry service = new ServiceEntry();
                                        service.setName(node.name);
                                        service.setHost(host);
                                        service.setStatus(node.status);
                                        service.setCount(node.count);
                                        ServiceContainer.this.addBean(service);
                                    }
                                }
                                for (String name : SERVER_NAMES) {
                                    if (ServiceContainer.this.contains(name)) continue;
                                    ServiceEntry entry = new ServiceEntry();
                                    entry.setName(name);
                                    entry.setStatus(AdminAPI.NodeStatus.Status.UNKNOWN);
                                    ServiceContainer.this.addBean(entry);
                                }
                            }
                            finally {
                                tableLock.unlock();
                            }
                        }
                    });
                    api.areAllServicesUp(true);
                    endpoint.close();
                    view.updateDone();
                }
                catch (MicroarrayException e) {
                    e.printStackTrace();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ConfigurationLoader.IllegalConfigurationException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private boolean contains(String name) {
        for (ServiceEntry entry : this.getItemIds()) {
            if (!name.equals(entry.getName())) continue;
            return true;
        }
        return false;
    }
}

