/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description.vvsadl;

import fi.csc.microarray.util.AdvancedStringTokenizer;
import java.util.Iterator;

public class Deseparator
implements Iterable<String[]>,
Iterator<String[]> {
    private AdvancedStringTokenizer ast;
    private int batchSize;
    private boolean atEnd = false;
    private String separator;

    public Deseparator(String separator, AdvancedStringTokenizer ast, int batchSize) {
        this.separator = separator;
        this.ast = ast;
        this.batchSize = batchSize;
    }

    @Override
    public Iterator<String[]> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.atEnd;
    }

    @Override
    public String[] next() {
        assert (!this.atEnd);
        String[] batch = new String[this.batchSize];
        for (int i = 0; i < batch.length; ++i) {
            batch[i] = this.ast.next();
        }
        if (batch[this.batchSize - 1].endsWith(this.separator)) {
            batch[this.batchSize - 1] = batch[this.batchSize - 1].substring(0, batch[this.batchSize - 1].length() - 1);
        } else if (this.ast.hasNext() && this.ast.peek().equals(this.separator)) {
            this.ast.next();
        } else {
            this.atEnd = true;
        }
        return batch;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

