/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataItemBase;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

public class DataFolder
extends DataItemBase {
    private List<DataItem> children = new LinkedList<DataItem>();
    private DataManager manager;

    public DataFolder(DataManager manager, String name) {
        this.manager = manager;
        this.name = name;
    }

    public void addChild(DataItem child) {
        boolean wasConnected = child.getParent() != null;
        child.setParent(this);
        this.children.add(child);
        if (child instanceof DataBean) {
            this.doBackwardsCompatibleTypeTagInitialisation((DataBean)child);
        }
        if (!wasConnected) {
            this.manager.dispatchEvent(new DataItemCreatedEvent(child));
        }
    }

    private void doBackwardsCompatibleTypeTagInitialisation(DataBean data) {
        try {
            String pcaOnValue;
            BufferedReader in;
            if (data.isContentTypeCompatitible("text/tab", "application/cel", "text/csv")) {
                data.addTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
            }
            if (data.isContentTypeCompatitible("text/tab")) {
                block35: {
                    in = null;
                    try {
                        in = new BufferedReader(new InputStreamReader(data.getContentByteStream()));
                        String line = in.readLine();
                        String[] split = line.split("\t");
                        if (split.length <= 4 || !"SEQNAMES".equals(split[1]) || !"START".equals(split[2]) || !"END".equals(split[3])) break block35;
                        data.addTypeTag(MicroarrayModule.TypeTags.CHROMOSOME_IN_SECOND_TABLE_COLUMN);
                        data.addTypeTag(MicroarrayModule.TypeTags.START_POSITION_IN_THIRD_TABLE_COLUMN);
                        data.addTypeTag(MicroarrayModule.TypeTags.END_POSITION_IN_FOURTH_TABLE_COLUMN);
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException(e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeIfPossible(in);
                            throw throwable;
                        }
                    }
                }
                IOUtils.closeIfPossible(in);
            }
            if (data.isContentTypeCompatitible("text/gtf")) {
                data.addTypeTag(MicroarrayModule.TypeTags.GTF_FILE);
                data.addTypeTag(BasicModule.TypeTags.TABLE_WITHOUT_COLUMN_NAMES);
                data.addTypeTag(MicroarrayModule.TypeTags.TABLE_WITH_HASH_HEADER);
            }
            if (data.isContentTypeCompatitible("text/vcf")) {
                data.addTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES);
                data.addTypeTag(MicroarrayModule.TypeTags.TABLE_WITH_DOUBLE_HASH_HEADER);
                data.addTypeTag(MicroarrayModule.TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN);
                data.addTypeTag(MicroarrayModule.TypeTags.START_POSITION_IN_SECOND_TABLE_COLUMN);
            }
            if (data.isContentTypeCompatitible("text/bed")) {
                data.addTypeTag(BasicModule.TypeTags.TABLE_WITHOUT_COLUMN_NAMES);
                data.addTypeTag(MicroarrayModule.TypeTags.CHROMOSOME_IN_FIRST_TABLE_COLUMN);
                data.addTypeTag(MicroarrayModule.TypeTags.START_POSITION_IN_SECOND_TABLE_COLUMN);
                data.addTypeTag(MicroarrayModule.TypeTags.END_POSITION_IN_THIRD_TABLE_COLUMN);
                in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(data.getContentByteStream()));
                    if (in.readLine().startsWith("track")) {
                        data.addTypeTag(BasicModule.TypeTags.TABLE_WITH_TITLE_ROW);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    IOUtils.closeIfPossible(in);
                }
            }
            if (!(Session.getSession().getPrimaryModule() instanceof MicroarrayModule)) {
                return;
            }
            Table chips = data.queryFeatures("/column/chip.*").asTable();
            if (data.isContentTypeCompatitible("application/cel")) {
                data.addTypeTag(MicroarrayModule.TypeTags.RAW_AFFYMETRIX_EXPRESSION_VALUES);
            } else if (data.queryFeatures("/column/sample").exists() && !data.queryFeatures("/phenodata").exists()) {
                data.addTypeTag(MicroarrayModule.TypeTags.RAW_EXPRESSION_VALUES);
            } else if (chips != null && chips.getColumnCount() > 0) {
                data.addTypeTag(MicroarrayModule.TypeTags.NORMALISED_EXPRESSION_VALUES);
            } else if (data.isContentTypeCompatitible("application/bam")) {
                data.addTypeTag(MicroarrayModule.TypeTags.BAM_FILE);
            } else if (data.isContentTypeCompatitible("chemical/x-fasta")) {
                data.addTypeTag(MicroarrayModule.TypeTags.FASTA_FILE);
            }
            if (data.queryFeatures("/identifier").exists()) {
                data.addTypeTag(MicroarrayModule.TypeTags.GENENAMES);
            }
            if (data.queryFeatures("/phenodata").exists()) {
                data.addTypeTag(BasicModule.TypeTags.PHENODATA);
            }
            if (data.queryFeatures("/column/p.*").exists() && data.queryFeatures("/column/FC*").exists()) {
                data.addTypeTag(MicroarrayModule.TypeTags.SIGNIFICANT_EXPRESSION_FOLD_CHANGES);
            }
            boolean isChipwise = false;
            OperationRecord.ParameterRecord pcaOn = data.getOperationRecord().getParameter("do.pca.on");
            if (pcaOn != null && (pcaOnValue = pcaOn.getValue()) != null && pcaOnValue.equals("chips")) {
                isChipwise = true;
            }
            if (data.getOperationRecord().getNameID().getID().equals("ordination-pca.R") && isChipwise) {
                data.addTypeTag(MicroarrayModule.TypeTags.EXPRESSION_PRIMARY_COMPONENTS_CHIPWISE);
            }
            if (chips != null && chips.getColumnNames().length > 1 && data.queryFeatures("/column/cluster").exists()) {
                data.addTypeTag(MicroarrayModule.TypeTags.CLUSTERED_EXPRESSION_VALUES);
            }
            if (data.isContentTypeCompatitible("text/plain", "text/bed", "text/tab") || data.isContentTypeCompatitible("application/octet-stream") && data.getName().contains(".bam-summary") || data.isContentTypeCompatitible("application/octet-stream") && (data.getName().endsWith(".bam") || data.getName().endsWith(".sam")) || data.isContentTypeCompatitible("application/octet-stream") && data.getName().endsWith(".bai")) {
                data.addTypeTag(MicroarrayModule.TypeTags.ORDERED_GENOMIC_ENTITIES);
            }
            if (data.queryFeatures("/clusters/som").exists()) {
                data.addTypeTag(MicroarrayModule.TypeTags.SOM_CLUSTERED_EXPRESSION_VALUES);
            }
        }
        catch (MicroarrayException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeChild(DataItem child) {
        child.setParent(null);
        this.children.remove(child);
        this.manager.dispatchEvent(new DataItemRemovedEvent(child));
    }

    public Iterable<DataItem> getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public DataFolder getChildFolder(String name) {
        for (DataItem child : this.getChildren()) {
            if (!(child instanceof DataFolder) || !child.getName().equals(name)) continue;
            return (DataFolder)child;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

