/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class WIGTrack
extends Track {
    private long maxBpLength;
    private long minBpLength;
    private Collection<RegionContent> values = new TreeSet<RegionContent>();
    private Color color;

    public WIGTrack(GBrowserView view, DataSource file, Color color, long minBpLength, long maxBpLength) {
        super(view, file);
        this.color = color;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Iterator<RegionContent> iter = this.values.iterator();
        float lastX = 1.0f;
        float lastY = 1.0f;
        if (this.values != null) {
            while (iter.hasNext()) {
                RegionContent value = iter.next();
                if (!value.region.intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                float x = (this.getView().bpToTrackFloat(value.region.start).floatValue() + this.getView().bpToTrackFloat(value.region.end).floatValue()) / 2.0f;
                float y = Float.parseFloat((String)value.values.get((Object)ColumnType.VALUE));
                drawables.add(new LineDrawable((int)lastX, this.getHeight() - (int)lastY, (int)x, this.getHeight() - (int)y, this.color));
                lastX = x;
                lastY = y;
            }
        }
        drawables.add(new LineDrawable((int)lastX, this.getHeight() - (int)lastY, this.getView().getWidth(), this.getHeight() - 1, this.color));
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        this.values.addAll(areaResult.getContents());
        this.getView().redraw();
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public int getHeight() {
        return 51;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.VALUE)));
        return datas;
    }
}

