/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cigar;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class ReadpartDataProvider
implements AreaResultListener {
    private GBrowserView view;
    private DataSource readData;
    private Collection<RegionContent> reads = new TreeSet<RegionContent>();
    private LinkedList<ReadPart> readParts = new LinkedList();
    private LinkedList<ReadPart> readPartsF = new LinkedList();
    private LinkedList<ReadPart> readPartsR = new LinkedList();
    private boolean needsRefresh = false;

    public ReadpartDataProvider(GBrowserView view, DataSource readData) {
        this.view = view;
        this.readData = readData;
        view.getQueueManager().addResultListener(readData, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAreaResult(AreaResult areaResult) {
        if (areaResult.getStatus().file == this.readData && !areaResult.getStatus().concise) {
            Collection<RegionContent> collection = this.reads;
            synchronized (collection) {
                this.reads.addAll(areaResult.getContents());
                this.needsRefresh = true;
            }
            this.view.redraw();
        }
    }

    public Iterable<ReadPart> getReadparts(Strand strand) {
        Collection<RegionContent> collection = this.reads;
        synchronized (collection) {
            if (this.needsRefresh) {
                this.refreshReadparts();
                this.needsRefresh = false;
            }
            switch (strand) {
                case BOTH: {
                    return this.readParts;
                }
                case FORWARD: {
                    return this.readPartsF;
                }
                case REVERSED: {
                    return this.readPartsR;
                }
            }
            throw new IllegalArgumentException("illegal strand: " + (Object)((Object)strand));
        }
    }

    private void refreshReadparts() {
        this.readParts.clear();
        this.readPartsF.clear();
        this.readPartsR.clear();
        Iterator<RegionContent> iter = this.reads.iterator();
        while (iter.hasNext()) {
            RegionContent read = iter.next();
            if (!read.region.intersects(this.view.getBpRegion())) {
                iter.remove();
                continue;
            }
            List<ReadPart> visibleRegions = Cigar.splitElements(read);
            for (ReadPart visibleRegion : visibleRegions) {
                if (!visibleRegion.intersects(this.view.getBpRegion())) continue;
                this.readParts.add(visibleRegion);
                if (read.values.get((Object)ColumnType.STRAND) == Strand.FORWARD) {
                    this.readPartsF.add(visibleRegion);
                    continue;
                }
                if (read.values.get((Object)ColumnType.STRAND) != Strand.REVERSED) continue;
                this.readPartsR.add(visibleRegion);
            }
        }
        Collections.sort(this.readParts);
        Collections.sort(this.readPartsF);
        Collections.sort(this.readPartsR);
    }
}

