/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageAndSNPTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GelTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.IntensityTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadPileTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadpartDataProvider;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReferenceSequenceTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;

public class ReadTrackGroup
extends TrackGroup {
    private final Color histogramColor = new Color(100, 100, 100);
    private final Color fontColor = Color.black;
    protected TitleTrack titleTrack;
    protected IntensityTrack readOverview;
    protected ReadPileTrack reads;
    protected ReferenceSequenceTrack seq;
    protected IntensityTrack readOverviewReversed;
    protected ReadPileTrack readsReversed;
    protected CoverageAndSNPTrack profileTrack;
    protected CoverageAndSNPTrack profileSNPTrack;
    protected GelTrack gelTrack;
    protected SeparatorTrack sepTrackReads;
    protected SeparatorTrack sepTrackSeq;
    protected SeparatorTrack sepTrackProfile;
    protected SeparatorTrack sepTrackProfileSNP;
    protected SeparatorTrack sepTrackQualityCoverage;
    protected SeparatorTrack sepTrackGel;
    private DataSource seqFile;
    private DataSource userData;
    private ReadpartDataProvider readpartProvider;
    private String title;
    private boolean initialised = false;
    private SeparatorTrack sepTrackReadOverview;

    public ReadTrackGroup(GBrowserView view, DataSource userData, DataSource seqFile, String title) {
        super(view);
        this.userData = userData;
        this.readpartProvider = new ReadpartDataProvider(view, userData);
        this.seqFile = seqFile;
        this.title = title;
    }

    public void initialise() {
        this.titleTrack = new TitleTrack(this.view, this.title, Color.black);
        this.tracks.add(this.titleTrack);
        this.addReadOverviewTrack();
        this.sepTrackReadOverview = new SeparatorTrack(this.view, Color.gray, 1, GBrowserConstants.SWITCH_VIEWS_AT, Long.MAX_VALUE);
        this.tracks.add(this.sepTrackReadOverview);
        this.reads = new ReadPileTrack(this.view, this.userData, this.readpartProvider, this.fontColor, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        this.tracks.add(this.reads);
        this.sepTrackReads = new SeparatorTrack(this.view, Color.gray, 1, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        this.sepTrackReads.setName("Reads");
        this.tracks.add(this.sepTrackReads);
        if (this.seqFile != null) {
            this.seq = new ReferenceSequenceTrack(this.view, this.seqFile, GBrowserConstants.SHOW_REFERENCE_AT);
            this.tracks.add(this.seq);
            this.sepTrackSeq = new SeparatorTrack(this.view, Color.gray, 1, 0L, GBrowserConstants.SHOW_REFERENCE_AT);
            this.sepTrackSeq.setName("Reads");
            this.tracks.add(this.sepTrackSeq);
        }
        this.addReadOverviewReversedTrack();
        this.readsReversed = new ReadPileTrack(this.view, this.userData, this.readpartProvider, this.fontColor, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        this.readsReversed.setStrand(Strand.REVERSED);
        this.tracks.add(this.readsReversed);
        SeparatorTrack sepTrackReads2 = new SeparatorTrack(this.view, Color.gray, 1, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        sepTrackReads2.setName("Reads");
        this.tracks.add(sepTrackReads2);
        Color forwardColor = new Color(0, 0, 0, 64);
        Color reverseColor = new Color(GBrowserConstants.COLOR_BLUE.getRed(), GBrowserConstants.COLOR_BLUE.getGreen(), GBrowserConstants.COLOR_BLUE.getBlue(), 64);
        Color totalColor = Color.gray;
        this.profileTrack = new CoverageAndSNPTrack(this.view, this.userData, this.readpartProvider, this.seqFile, forwardColor, reverseColor, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        this.profileTrack.setName("ProfileTrack");
        this.tracks.add(this.profileTrack);
        this.sepTrackProfile = new SeparatorTrack(this.view, Color.gray, 1, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        this.sepTrackProfile.setName("ProfileTrack");
        this.tracks.add(this.sepTrackProfile);
        this.profileSNPTrack = new CoverageAndSNPTrack(this.view, this.userData, this.readpartProvider, this.seqFile, totalColor, null, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        this.profileSNPTrack.setName("ProfileSNPTrack");
        this.tracks.add(this.profileSNPTrack);
        this.sepTrackProfileSNP = new SeparatorTrack(this.view, Color.gray, 1, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        this.sepTrackProfileSNP.setName("ProfileSNPTrack");
        this.tracks.add(this.sepTrackProfileSNP);
        this.gelTrack = new GelTrack(this.view, this.userData, this.readpartProvider, Color.WHITE, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        this.gelTrack.setStrand(Strand.BOTH);
        this.tracks.add(this.gelTrack);
        this.initialised = true;
    }

    protected void addReadOverviewReversedTrack() {
        this.readOverviewReversed = new IntensityTrack(this.view, this.userData, this.histogramColor, GBrowserConstants.SWITCH_VIEWS_AT, false, true);
        this.readOverviewReversed.setStrand(Strand.REVERSED);
        this.readOverviewReversed.setName("ReadOverview");
        this.tracks.add(this.readOverviewReversed);
    }

    protected void addReadOverviewTrack() {
        this.readOverview = new IntensityTrack(this.view, this.userData, this.histogramColor, GBrowserConstants.SWITCH_VIEWS_AT, false, true);
        this.readOverview.setName("ReadOverview");
        this.tracks.add(this.readOverview);
    }

    public void setVisibleSNP(boolean b) {
        this.check();
        if (b) {
            this.reads.enableSNPHighlight(this.seqFile);
            this.readsReversed.enableSNPHighlight(this.seqFile);
            this.profileSNPTrack.enableSNPHighlight();
        } else {
            this.reads.disableSNPHiglight();
            this.readsReversed.disableSNPHiglight();
            this.profileSNPTrack.disableSNPHighlight();
        }
        this.view.fireAreaRequests();
        this.view.redraw();
    }

    @Override
    public String getName() {
        this.check();
        return "Read Track Group";
    }

    @Override
    public void showOrHide(String name, boolean state) {
        this.check();
        super.showOrHide(name, state);
        if (name.equals("highlightSNP")) {
            this.setVisibleSNP(state);
        }
    }

    private void check() {
        if (!this.initialised) {
            throw new IllegalStateException("you must call initialise() after creating this object");
        }
    }
}

