/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GeneTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.IntensityTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReferenceSNPTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RepeatMaskerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RulerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TranscriptTrack;
import java.awt.Color;
import java.util.LinkedList;

public class GeneTrackGroup
extends TrackGroup {
    protected TranscriptTrack transcript;
    protected IntensityTrack geneOverview;
    protected Track gene;
    protected ReferenceSNPTrack snpTrack = null;
    protected RepeatMaskerTrack repeatMasker;
    protected IntensityTrack geneOverviewReversed;
    protected Track geneReversed;
    protected TranscriptTrack transcriptReversed;
    protected ReferenceSNPTrack snpTrackReversed;

    public GeneTrackGroup(GBrowserView dataView, DataSource annotationDataSource, TabixDataSource repeatDataSource) {
        super(dataView);
        if (annotationDataSource != null) {
            this.transcript = new TranscriptTrack(dataView, annotationDataSource, GBrowserConstants.SWITCH_VIEWS_AT);
            this.transcript.setStrand(Strand.FORWARD);
            this.geneOverview = new IntensityTrack(dataView, annotationDataSource, GBrowserConstants.COLOR_BLUE_BRIGHTER, 10000000L, true, false);
            this.geneOverview.setStrand(Strand.FORWARD);
            this.gene = new GeneTrack(dataView, annotationDataSource, GBrowserConstants.COLOR_BLUE_BRIGHTER, GBrowserConstants.SWITCH_VIEWS_AT, 10000000L);
            this.gene.setStrand(Strand.FORWARD);
        }
        if (repeatDataSource != null) {
            this.repeatMasker = new RepeatMaskerTrack(dataView, repeatDataSource, 0L, GBrowserConstants.SWITCH_VIEWS_AT);
        }
        if (annotationDataSource != null) {
            this.geneOverviewReversed = new IntensityTrack(dataView, annotationDataSource, GBrowserConstants.COLOR_BLUE_BRIGHTER, 10000000L, true, false);
            this.geneOverviewReversed.setStrand(Strand.REVERSED);
            this.geneReversed = new GeneTrack(dataView, annotationDataSource, GBrowserConstants.COLOR_BLUE_BRIGHTER, GBrowserConstants.SWITCH_VIEWS_AT, 10000000L);
            this.geneReversed.setStrand(Strand.REVERSED);
            this.transcriptReversed = new TranscriptTrack(dataView, annotationDataSource, GBrowserConstants.SWITCH_VIEWS_AT);
            this.transcriptReversed.setStrand(Strand.REVERSED);
        }
        this.adds();
    }

    public void adds() {
        this.tracks = new LinkedList();
        this.tracks.add(new TitleTrack(this.view, "Annotations", Color.black));
        if (this.transcript != null) {
            this.tracks.add(this.transcript);
            this.tracks.add(this.geneOverview);
            this.tracks.add(this.gene);
        }
        if (this.snpTrack != null) {
            this.tracks.add(this.snpTrack);
        }
        this.tracks.add(new RulerTrack(this.view));
        if (this.snpTrackReversed != null) {
            this.tracks.add(this.snpTrackReversed);
        }
        if (this.repeatMasker != null) {
            this.tracks.add(this.repeatMasker);
        }
        if (this.transcript != null) {
            this.tracks.add(this.geneOverviewReversed);
            this.tracks.add(this.geneReversed);
            this.tracks.add(this.transcriptReversed);
        }
    }

    @Override
    public String getName() {
        return "GeneTrackGroup";
    }

    private void setChangeSNP(boolean change) {
        if (change) {
            this.snpTrack.changeSNPView();
            this.snpTrackReversed.changeSNPView();
        } else {
            this.snpTrack.returnSNPView();
            this.snpTrackReversed.returnSNPView();
        }
        this.view.fireAreaRequests();
        this.view.redraw();
    }

    @Override
    public void showOrHide(String name, boolean state) {
        super.showOrHide(name, state);
        if (this.snpTrack != null && name.equals("changeSNP")) {
            this.setChangeSNP(state);
        }
    }

    @Override
    public LayoutTool.LayoutMode getLayoutMode() {
        return LayoutTool.LayoutMode.FIXED;
    }

    @Override
    public int getHeight() {
        return 250;
    }
}

