/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.CircularView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.HorizontalView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutComponent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutContainer;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.OverviewHorizontalView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.general.DatasetChangeEvent;

public class GBrowserPlot
extends Plot
implements LayoutContainer {
    private List<GBrowserView> views = new LinkedList<GBrowserView>();
    private GBrowserView dataView = null;
    private OverviewHorizontalView overviewView = null;
    private ReadScale readScale = ReadScale.AUTO;
    public TooltipAugmentedChartPanel chartPanel;

    public GBrowserPlot(TooltipAugmentedChartPanel panel, boolean horizontal) {
        this.chartPanel = panel;
        this.chartPanel.setLayout(null);
        this.overviewView = new OverviewHorizontalView(this);
        this.overviewView.margin = 0;
        this.views.add(this.overviewView);
        if (horizontal) {
            this.dataView = new HorizontalView(this, true, true, false);
        } else {
            this.dataView = new CircularView(this, true, true, false);
            this.dataView.margin = 20;
        }
        this.views.add(this.dataView);
        this.chartPanel.addTooltipRequestProcessor(this.dataView);
        this.dataView.addRegionListener(new RegionListener(){

            @Override
            public void regionChanged(Region bpRegion) {
                ((GBrowserPlot)GBrowserPlot.this).overviewView.highlight = bpRegion;
                GBrowserPlot.this.overviewView.setBpRegion(new RegionDouble(0.0, 2.5E8, bpRegion.start.chr), false);
            }
        });
        this.overviewView.addOverviewRegionListener(new RegionListener(){

            @Override
            public void regionChanged(Region bpRegion) {
                GBrowserPlot.this.dataView.setBpRegion(new RegionDouble(bpRegion), false);
            }
        });
    }

    public GBrowserView getDataView() {
        return this.dataView;
    }

    public GBrowserView getOverviewView() {
        return this.overviewView;
    }

    public void start(String chromosome, Double chromosomeSizeBp, Long position, Long length) {
        this.overviewView.setBpRegion(new RegionDouble(0.0, chromosomeSizeBp, new Chromosome(chromosome)), false);
        this.moveDataBpRegion(new Chromosome(chromosome), position, length);
    }

    public void moveDataBpRegion(Chromosome moveToChr, Long moveToBp, Long length) {
        RegionDouble bpCoordRegion = new RegionDouble(new Double(moveToBp - length / 2L), new Double(moveToBp + length / 2L), moveToChr);
        this.dataView.setBpRegion(bpCoordRegion, false);
    }

    public void addDataRegionListener(RegionListener regionListener) {
        this.dataView.addRegionListener(regionListener);
    }

    public String getPlotType() {
        return "GenomeBrowser";
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(plotArea);
            info.setDataArea(plotArea);
        }
        Shape savedClip = g2.getClip();
        Rectangle viewArea = (Rectangle)plotArea.getBounds().clone();
        LayoutTool.doLayout(this, (int)plotArea.getBounds().getHeight());
        for (int i = 0; i < this.views.size(); ++i) {
            GBrowserView view = this.views.get(i);
            viewArea.height = view.getHeight();
            g2.setClip(viewArea);
            view.draw(g2, plotArea.getBounds(), viewArea);
            viewArea.y += viewArea.height;
        }
        this.chartPanel.setScrollGroupOrder(this.getScrollGroups(), (int)plotArea.getHeight());
        g2.setClip(savedClip);
    }

    private Collection<ScrollGroup> getScrollGroups() {
        LinkedList<ScrollGroup> groups = new LinkedList<ScrollGroup>();
        for (GBrowserView view : this.views) {
            groups.addAll(view.getScrollGroups());
        }
        return groups;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof GBrowserPlot;
    }

    public void redraw() {
        this.datasetChanged(new DatasetChangeEvent((Object)this, null));
    }

    public Collection<GBrowserView> getViews() {
        return this.views;
    }

    public ReadScale getReadScale() {
        return this.readScale;
    }

    public void setReadScale(ReadScale readScale) {
        this.readScale = readScale;
        this.dataView.redraw();
    }

    public void setFullLayoutMode(boolean enabled) {
        LayoutTool.setFullLayoutMode(this, enabled);
        this.redraw();
    }

    public void clean() {
        this.chartPanel.removeTooltipRequestProcessor();
        this.overviewView.clean();
        this.dataView.clean();
        this.dataView = null;
    }

    @Override
    public Collection<? extends LayoutComponent> getLayoutComponents() {
        return this.views;
    }

    public void initializeTracks() {
        for (GBrowserView view : this.views) {
            for (Track track : view.getTracks()) {
                track.initializeListener();
            }
        }
    }

    public void updateData() {
        for (GBrowserView view : this.views) {
            view.fireAreaRequests();
        }
    }

    public static enum ReadScale {
        XS("10", 10),
        SMALL("50", 50),
        MEDIUM("100", 100),
        MEDIUM2("250", 250),
        LARGE("500", 500),
        XL("1000", 1000),
        XXL("5000", 5000),
        XXXL("10000", 10000),
        AUTO("Automatic", 0);

        private String name;
        public Integer numReads;

        private ReadScale(String name, Integer numReads) {
            this.name = name;
            this.numReads = numReads;
        }

        public String toString() {
            return this.name;
        }
    }
}

