/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.ChunkTreeHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ByteRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ChunkFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.FsfStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.util.LinkedList;

public class TreeNode {
    private ChunkTreeHandlerThread tree;
    public BpCoord nodeBpStart;
    public ByteRegion byteRegion;
    private TreeNode left;
    private TreeNode right;
    private TreeNode parent;
    private int depth;
    private ByteRegion inexactByteRegion;
    private boolean isLeaf;

    public TreeNode(ByteRegion nodeByteRegion, ChunkTreeHandlerThread tree, TreeNode parent) {
        this.tree = tree;
        this.parent = parent;
        this.byteRegion = nodeByteRegion.clone();
        this.inexactByteRegion = nodeByteRegion.clone();
        this.isLeaf = nodeByteRegion.getLength() <= tree.getInputParser().getDefaulChunkLength();
        this.depth = parent == null ? 0 : parent.depth + 1;
    }

    private void createChildrenIfNecessary() {
        if (!(this.isLeaf || this.left != null && this.right != null)) {
            this.left = new TreeNode(new ByteRegion(this.inexactByteRegion.start, (long)this.inexactByteRegion.getMid() - 1L, false), this.tree, this);
            this.right = new TreeNode(new ByteRegion((long)this.inexactByteRegion.getMid(), this.inexactByteRegion.end, false), this.tree, this);
        }
    }

    private void updateNodeBpStart(AreaRequest areaRequest, TreeNode source) {
        if (this.isLeaf) {
            areaRequest.status.bpSearchSource = source;
            this.tree.createFileRequest(areaRequest, this.byteRegion, this);
        } else {
            this.createChildrenIfNecessary();
            this.left.updateNodeBpStart(areaRequest, source);
        }
    }

    public void processAreaRequest(AreaRequest areaRequest) {
        if (this.isLeaf) {
            this.tree.createFileRequest(areaRequest, this.byteRegion, this);
        } else {
            this.createChildrenIfNecessary();
            if (this.right.nodeBpStart == null) {
                this.right.updateNodeBpStart(areaRequest, this);
            } else {
                try {
                    AreaRequest clone;
                    boolean recurseRight;
                    boolean recurseLeft = areaRequest.start.compareTo(this.right.nodeBpStart) < 0;
                    boolean bl = recurseRight = areaRequest.end.compareTo(this.right.nodeBpStart) > 0;
                    if (recurseLeft) {
                        clone = areaRequest.clone();
                        this.left.processAreaRequest(clone);
                    }
                    if (recurseRight) {
                        clone = areaRequest.clone();
                        this.right.processAreaRequest(clone);
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void processFileResult(ChunkFileResult fileResult) {
        boolean hollowNode = "".equals(fileResult.chunk.getContent());
        if (!hollowNode) {
            if (this.isLeaf) {
                if (this.byteRegion.exact && fileResult.exactRegion != null) {
                    this.byteRegion = fileResult.exactRegion;
                }
                if (this.nodeBpStart == null) {
                    FileParser parser = fileResult.chunkParser;
                    this.nodeBpStart = parser.getBpRegion((Chunk)fileResult.chunk).start;
                    if (this.parent != null) {
                        this.parent.nodeBpStartUpdated(this);
                    }
                }
                if (fileResult.request.areaRequest.intersects(fileResult.chunkParser.getBpRegion(fileResult.chunk))) {
                    this.createAreaResultOfAllRows(fileResult.chunk, fileResult.chunkParser, fileResult.request.areaRequest, fileResult.status);
                }
            } else if (fileResult.status.bpSearchSource == this) {
                fileResult.status.bpSearchSource = null;
                this.processAreaRequest(fileResult.request.areaRequest);
            }
            if (this.parent != null) {
                this.parent.processFileResult(fileResult);
            }
        }
    }

    private void nodeBpStartUpdated(TreeNode source) {
        if (source == this.left) {
            this.nodeBpStart = this.left.nodeBpStart;
            if (this.parent != null) {
                this.parent.nodeBpStartUpdated(this);
            }
        }
    }

    public void createAreaResultOfAllRows(Chunk chunk, FileParser chunkParser, AreaRequest areaRequest, FsfStatus status) {
        LinkedList<RegionContent> contents = new LinkedList<RegionContent>();
        for (RegionContent rc : chunkParser.getAll(chunk, areaRequest.requestedContents)) {
            if (!areaRequest.intersects(rc.region)) continue;
            contents.add(rc);
        }
        if (!contents.isEmpty()) {
            this.tree.createAreaResult(new AreaResult(status, contents));
        }
    }
}

