/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.CytobandFileFetcherThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.CytobandDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ParsedFileResult;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class CytobandHandlerThread
extends AreaRequestHandler {
    private CytobandDataSource dataSource;
    private CytobandFileFetcherThread fileFetcher;
    private BlockingQueue<BpCoordFileRequest> fileRequestQueue = new LinkedBlockingQueue<BpCoordFileRequest>();
    private ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue = new ConcurrentLinkedQueue();

    public CytobandHandlerThread(DataSource file, Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        super(areaRequestQueue, areaResultListener);
        this.dataSource = (CytobandDataSource)file;
    }

    @Override
    public synchronized void run() {
        this.fileFetcher = new CytobandFileFetcherThread(this.fileRequestQueue, this.fileResultQueue, this, this.dataSource);
        this.fileFetcher.start();
        super.run();
    }

    @Override
    protected boolean checkOtherQueues() {
        ParsedFileResult fileResult = null;
        fileResult = this.fileResultQueue.poll();
        if (fileResult != null) {
            this.processFileResult(fileResult);
        }
        return fileResult != null;
    }

    private void processFileResult(ParsedFileResult fileResult) {
        this.createAreaResult(new AreaResult(fileResult.getStatus(), fileResult.getContents()));
    }

    @Override
    protected void processAreaRequest(AreaRequest areaRequest) {
        super.processAreaRequest(areaRequest);
        if (areaRequest.status.poison) {
            BpCoordFileRequest fileRequest = new BpCoordFileRequest(areaRequest, null, null, areaRequest.status);
            this.fileRequestQueue.add(fileRequest);
            return;
        }
        this.fileRequestQueue.add(new BpCoordFileRequest(areaRequest, areaRequest.start, areaRequest.end, areaRequest.status));
    }
}

