/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Cytoband;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.CytobandHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.CytobandDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ParsedFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CytobandFileFetcherThread
extends Thread {
    private BlockingQueue<BpCoordFileRequest> fileRequestQueue;
    private ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue;
    private CytobandHandlerThread areaRequestThread;
    private CytobandDataSource dataSource;
    SortedSet<Cytoband> cytobands;
    private boolean poison = false;

    public CytobandFileFetcherThread(BlockingQueue<BpCoordFileRequest> fileRequestQueue, ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue, CytobandHandlerThread areaRequestThread, CytobandDataSource dataSource) {
        this.fileRequestQueue = fileRequestQueue;
        this.fileResultQueue = fileResultQueue;
        this.areaRequestThread = areaRequestThread;
        this.dataSource = dataSource;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.poison) {
            try {
                for (BpCoordFileRequest fileRequest : this.fileRequestQueue) {
                    if (!fileRequest.getStatus().poison) continue;
                    this.poison = true;
                    return;
                }
                this.processFileRequest(this.fileRequestQueue.take());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void readFile() throws IOException {
        String line;
        while ((line = this.dataSource.readLine()) != null) {
            String[] cols = line.split("\t");
            String chr = cols[0];
            String seq_region_start = cols[2];
            String seq_region_end = cols[3];
            String band = cols[4];
            String stain = cols[5];
            if (chr == null) continue;
            Region region = new Region(Long.decode(seq_region_start), Long.decode(seq_region_end), new Chromosome(chr));
            Cytoband cytoband = new Cytoband(region, band, stain);
            this.cytobands.add(cytoband);
        }
    }

    private void processFileRequest(BpCoordFileRequest fileRequest) throws IOException {
        if (fileRequest.getStatus().poison) {
            this.poison = true;
            return;
        }
        if (this.cytobands == null) {
            this.cytobands = new TreeSet<Cytoband>();
            this.readFile();
        }
        AreaRequest request = fileRequest.areaRequest;
        SortedSet<Cytoband> filtered = this.cytobands.subSet(new Cytoband(request.start), new Cytoband(request.end));
        ArrayList<RegionContent> resultList = new ArrayList<RegionContent>();
        for (Cytoband cband : filtered) {
            LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
            values.put(ColumnType.VALUE, cband);
            resultList.add(new RegionContent(cband.getRegion(), values));
        }
        ParsedFileResult result = new ParsedFileResult(resultList, fileRequest, request, request.status);
        this.fileResultQueue.add(result);
        this.areaRequestThread.notifyAreaRequestHandler();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " - " + this.dataSource;
    }
}

