/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.ChunkFileFetcherThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.TreeNode;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ByteRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ChunkFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ChunkFileResult;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ChunkTreeHandlerThread
extends AreaRequestHandler {
    private TreeNode rootNode;
    private BlockingQueue<ChunkFileRequest> fileRequestQueue = new LinkedBlockingQueue<ChunkFileRequest>();
    private ConcurrentLinkedQueue<ChunkFileResult> fileResultQueue = new ConcurrentLinkedQueue();
    private ChunkFileFetcherThread fileFetcher;
    private static final boolean DEBUG = false;
    private FileParser inputParser;
    private ChunkDataSource file;

    public ChunkTreeHandlerThread(DataSource file, Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        super(areaRequestQueue, areaResultListener);
        this.file = (ChunkDataSource)file;
        this.inputParser = this.file.getFileParser();
    }

    @Override
    public synchronized void run() {
        try {
            this.fileFetcher = new ChunkFileFetcherThread(this.fileRequestQueue, this.fileResultQueue, this, this.inputParser);
            this.createTree(this.fileFetcher.getFileLength());
            this.fileFetcher.start();
            super.run();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean checkOtherQueues() {
        ChunkFileResult fileResult = null;
        fileResult = this.fileResultQueue.poll();
        if (fileResult != null) {
            fileResult.status.fileResultCount = this.fileResultQueue.size();
            this.processFileResult(fileResult);
        }
        return fileResult != null;
    }

    private void createTree(long fileLength) throws IOException {
        this.rootNode = new TreeNode(new ByteRegion(this.file.getHeaderLength(), fileLength, false), this, null);
    }

    private void processFileResult(ChunkFileResult fileResult) {
        fileResult.request.node.processFileResult(fileResult);
    }

    @Override
    protected void processAreaRequest(AreaRequest areaRequest) {
        super.processAreaRequest(areaRequest);
        if (areaRequest.status.poison) {
            ChunkFileRequest fileRequest = new ChunkFileRequest(areaRequest, null, null, areaRequest.status);
            this.fileRequestQueue.add(fileRequest);
            return;
        }
        this.rootNode.processAreaRequest(areaRequest);
    }

    public void createFileRequest(AreaRequest areaRequest, ByteRegion byteRegion, TreeNode node) {
        areaRequest.status.maybeClearQueue(this.fileRequestQueue);
        this.fileRequestQueue.add(new ChunkFileRequest(areaRequest, byteRegion.clone(), node, areaRequest.status));
    }

    public FileParser getInputParser() {
        return this.inputParser;
    }

    public ChunkDataSource getFile() {
        return this.file;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " - " + this.file;
    }
}

