/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.VisualConstants;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class GBrowserStarter {
    private static void checkData(File ... files) {
        boolean fileNotFoundFail = false;
        for (File file : files) {
            if (file.exists()) continue;
            System.err.println("File not found: " + file);
            fileNotFoundFail = true;
        }
        if (fileNotFoundFail) {
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        DirectoryLayout.initialiseStandaloneClientLayout();
        String dataPath = System.getProperty("user.home") + "/chipster/";
        File BAM_DATA_FILE = new File(dataPath + "hg19_chr20.bam");
        File BAI_DATA_FILE = new File(dataPath + "hg19_chr20.bam.bai");
        File VCF_DATA_FILE = new File(dataPath + "var.flt.vcf");
        LinkedList<GBrowser.Interpretation> interpretations = new LinkedList<GBrowser.Interpretation>();
        for (int i = 0; i < 6; ++i) {
            GBrowser.Interpretation reads = new GBrowser.Interpretation(GBrowser.TrackType.READS, new GBrowser.DataFile(BAM_DATA_FILE));
            reads.setIndexData(new GBrowser.DataFile(BAI_DATA_FILE));
            interpretations.add(reads);
        }
        interpretations.add(new GBrowser.Interpretation(GBrowser.TrackType.VCF, new GBrowser.DataFile(VCF_DATA_FILE)));
        GBrowserStarter.checkData(BAM_DATA_FILE, BAI_DATA_FILE);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        BasicGBrowser browser = new BasicGBrowser();
        browser.initialise();
        JPanel parameterPanel = browser.getParameterPanel();
        JComponent component = browser.getVisualisation(interpretations);
        JSplitPane split = new JSplitPane(1, component, parameterPanel);
        split.setDividerLocation(1000);
        frame.add(split);
        frame.setSize(1280, 800);
        frame.setVisible(true);
    }

    private static class BasicGBrowser
    extends GBrowser {
        private BasicGBrowser() {
        }

        @Override
        public ImageIcon getIcon(String path) {
            return new ImageIcon(VisualConstants.class.getResource(path));
        }

        @Override
        public URL getRemoteAnnotationsUrl() throws Exception {
            return new URL("http://chipster-filebroker.csc.fi:8080/public/annotations");
        }

        @Override
        public File getLocalAnnotationDir() throws IOException {
            return new File(System.getProperty("user.home") + "/.chipster/annotations");
        }
    }
}

