/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BedTabixHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.ChunkTreeHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.GeneSearchHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.GtfTabixHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.TabixSummaryHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.CytobandDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.IndexedFastaDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.SAMDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.TabixSummaryDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.BEDParserWithCoordinateConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ElandParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.HeaderTsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.VcfParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserSettings;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GeneIndexActions;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ViewLimiter;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack3D;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackFactory;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.RegionOperations;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.SamBamUtils;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import fi.csc.microarray.util.BrowserLauncher;
import fi.csc.microarray.util.IOUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class GBrowser
implements ComponentListener {
    static final String WAITPANEL = "waitpanel";
    static final String PLOTPANEL = "plotpanel";
    private List<TrackDefinition> tracks = new LinkedList<TrackDefinition>();
    private GBrowserPlot plot;
    private JPanel plotPanel = new JPanel(new CardLayout());
    private AnnotationManager annotationManager;
    private GeneIndexActions gia;
    private ViewLimiter viewLimiter;
    protected boolean geneSearchDone;
    private GBrowserSettings settings;
    private List<Interpretation> interpretations;

    public void initialise() throws Exception {
        this.annotationManager = new AnnotationManager(this);
        this.annotationManager.initialize();
        this.settings = new GBrowserSettings();
        this.settings.initialise(this);
    }

    private void createAvailableTracks() {
        this.tracks.add(new TrackDefinition(AnnotationManager.AnnotationType.GTF_TABIX.getId(), new Interpretation(TrackType.GENES, null)));
        this.tracks.add(new TrackDefinition(AnnotationManager.AnnotationType.CYTOBANDS.getId(), new Interpretation(TrackType.CYTOBANDS, null)));
        for (int i = 0; i < this.interpretations.size(); ++i) {
            Interpretation interpretation = this.interpretations.get(i);
            this.tracks.add(new TrackDefinition(interpretation.primaryData.getName(), interpretation));
        }
        this.settings.updateDatasetSwitches();
    }

    public void setFullHeight(boolean fullHeight) {
        this.plot.setFullLayoutMode(fullHeight);
    }

    public JComponent getVisualisation(List<Interpretation> interpretations) throws IOException {
        this.interpretations = interpretations;
        this.settings.updateInterpretations();
        this.tracks.clear();
        this.createAvailableTracks();
        JPanel waitPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        waitPanel.add((Component)new JLabel("<html><p style=\"font-size: larger\">Please select genome and click " + this.settings.getGoButtonText() + "</p></html>"), c);
        this.plotPanel.add((Component)waitPanel, WAITPANEL);
        return this.plotPanel;
    }

    public void updateCoverageScale() {
        this.plot.setReadScale(this.settings.getCoverageScale());
    }

    private AnnotationManager.Genome getGenome() {
        return this.settings.getGenome();
    }

    public void updateTracks() {
        this.plot.getOverviewView().clean();
        this.plot.getDataView().clean();
        AnnotationManager.Genome genome = this.getGenome();
        ScrollGroup overview = new ScrollGroup("Overview");
        AnnotationScrollGroup annotations = new AnnotationScrollGroup();
        this.plot.getDataView().addTrackGroup(new TrackGroup(new SeparatorTrack3D(this.plot.getDataView(), 0L, Long.MAX_VALUE, true)));
        block37: for (TrackDefinition track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            switch (track.interpretation.type) {
                case CYTOBANDS: {
                    URL cytobandUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.CYTOBANDS);
                    try {
                        if (cytobandUrl == null) continue block37;
                        CytobandDataSource cytobandDataSource = new CytobandDataSource(cytobandUrl);
                        overview.addTrackGroup(TrackFactory.getCytobandTrackGroup(this.plot, cytobandDataSource));
                        this.viewLimiter = new ViewLimiter(this.plot.getOverviewView().getQueueManager(), cytobandDataSource, this.plot.getOverviewView());
                        this.plot.getDataView().setViewLimiter(this.viewLimiter);
                        this.plot.getOverviewView().setViewLimiter(this.viewLimiter);
                    }
                    catch (FileNotFoundException e) {
                        this.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    break;
                }
                case GENES: {
                    URL gtfUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF_TABIX);
                    URL gtfIndexUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.GTF_TABIX_INDEX);
                    URL repeatUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REPEAT);
                    URL repeatIndexUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REPEAT_INDEX);
                    TabixDataSource gtfDataSource = null;
                    TabixDataSource repeatDataSource = null;
                    try {
                        if (gtfUrl != null && gtfIndexUrl != null) {
                            gtfDataSource = new TabixDataSource(gtfUrl, gtfIndexUrl, GtfTabixHandlerThread.class);
                        }
                        if (repeatUrl != null && repeatIndexUrl != null) {
                            repeatDataSource = new TabixDataSource(repeatUrl, repeatIndexUrl, BedTabixHandlerThread.class);
                        }
                        TrackGroup geneGroup = TrackFactory.getGeneTrackGroup(this.plot, gtfDataSource, repeatDataSource);
                        track.setTrackGroup(geneGroup);
                        annotations.addTrackGroup(geneGroup);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    catch (IOException e) {
                        this.reportException(e);
                    }
                    break;
                }
                case REFERENCE: {
                    break;
                }
                case TRANSCRIPTS: {
                    break;
                }
            }
        }
        this.plot.getOverviewView().addScrollGroup(overview);
        this.plot.getDataView().addScrollGroup(annotations);
        this.plot.getDataView().addTrackGroup(TrackFactory.getThickSeparatorTrackGroup(this.plot));
        ScrollGroup samples = new ScrollGroup("Samples", true);
        boolean firstReadTrack = true;
        for (TrackDefinition track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            try {
                DataSource treatmentData;
                File file;
                File file2 = file = track.interpretation.primaryData == null ? null : track.interpretation.primaryData.getLocalFile();
                if (track.interpretation.type != TrackType.READS) continue;
                if (!firstReadTrack) {
                    samples.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
                } else {
                    firstReadTrack = false;
                }
                URL fastaUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE);
                URL fastaIndexUrl = this.getAnnotationUrl(genome, AnnotationManager.AnnotationType.REFERENCE_INDEX);
                IndexedFastaDataSource refSeqDataSource = null;
                if (fastaUrl != null && fastaIndexUrl != null) {
                    refSeqDataSource = new IndexedFastaDataSource(fastaUrl, fastaIndexUrl);
                }
                if (track.interpretation.summaryDatas.size() == 0) {
                    treatmentData = this.createReadDataSource(track.interpretation.primaryData, track.interpretation.indexData, this.tracks);
                    TrackGroup readGroup = TrackFactory.getReadTrackGroup(this.plot, treatmentData, refSeqDataSource, track.interpretation.primaryData.getName());
                    track.setTrackGroup(readGroup);
                    samples.addTrackGroup(readGroup);
                    continue;
                }
                treatmentData = this.createReadDataSource(track.interpretation.primaryData, track.interpretation.indexData, this.tracks);
                TrackGroup readGroupWithSummary = TrackFactory.getReadSummaryTrackGroup(this.plot, treatmentData, refSeqDataSource, track.interpretation.primaryData.getName(), new TabixDataSource(file.toURI().toURL(), null, (Class<? extends AreaRequestHandler>)TabixSummaryHandlerThread.class));
                track.setTrackGroup(readGroupWithSummary);
                samples.addTrackGroup(readGroupWithSummary);
            }
            catch (IOException e) {
                this.reportException(e);
            }
            catch (URISyntaxException e) {
                this.reportException(e);
            }
            catch (GBrowserException e) {
                e.printStackTrace();
            }
        }
        this.plot.getDataView().addScrollGroup(samples);
        this.plot.getDataView().addTrackGroup(TrackFactory.getThickSeparatorTrackGroup(this.plot));
        ScrollGroup analysis = new ScrollGroup("Analysis");
        boolean firstPeakTrack = true;
        for (TrackDefinition track : this.tracks) {
            if (!track.checkBox.isSelected()) continue;
            URL fileUrl = null;
            if (track.interpretation.primaryData != null) {
                try {
                    File file = track.interpretation.primaryData.getLocalFile();
                    fileUrl = file.toURI().toURL();
                }
                catch (IOException e) {
                    this.reportException(e);
                }
            }
            switch (track.interpretation.type) {
                case REGIONS: 
                case REGIONS_WITH_HEADER: 
                case VCF: {
                    if (!firstPeakTrack) {
                        analysis.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
                        break;
                    }
                    firstPeakTrack = false;
                    break;
                }
            }
            switch (track.interpretation.type) {
                case REGIONS: {
                    ChunkDataSource regionData;
                    analysis.addTrack(TrackFactory.getTitleTrack(this.plot, track.interpretation.primaryData.getName()));
                    try {
                        regionData = new ChunkDataSource(fileUrl, new BEDParserWithCoordinateConversion(), ChunkTreeHandlerThread.class);
                        regionData.checkSorting();
                        analysis.addTrackGroup(TrackFactory.getPeakTrackGroup(this.plot, regionData));
                    }
                    catch (FileNotFoundException e) {
                        this.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    catch (IOException e) {
                        this.reportException(e);
                    }
                    catch (UnsortedDataException e) {
                        this.showDialog("Unsorted data", e.getMessage(), null, true, false, true);
                    }
                    break;
                }
                case REGIONS_WITH_HEADER: {
                    ChunkDataSource regionData;
                    analysis.addTrack(TrackFactory.getTitleTrack(this.plot, track.interpretation.primaryData.getName()));
                    try {
                        regionData = new ChunkDataSource(fileUrl, new HeaderTsvParser(), ChunkTreeHandlerThread.class);
                        analysis.addTrackGroup(TrackFactory.getPeakTrackGroup(this.plot, regionData));
                    }
                    catch (FileNotFoundException e) {
                        this.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    break;
                }
                case VCF: {
                    ChunkDataSource regionData;
                    analysis.addTrack(TrackFactory.getTitleTrack(this.plot, track.interpretation.primaryData.getName()));
                    try {
                        regionData = new ChunkDataSource(fileUrl, new VcfParser(), ChunkTreeHandlerThread.class);
                        analysis.addTrackGroup(TrackFactory.getPeakTrackGroup(this.plot, regionData));
                    }
                    catch (FileNotFoundException e) {
                        this.reportException(e);
                    }
                    catch (URISyntaxException e) {
                        this.reportException(e);
                    }
                    break;
                }
            }
        }
        this.plot.getDataView().addScrollGroup(analysis);
        this.plot.getDataView().addTrackGroup(new TrackGroup(new SeparatorTrack3D(this.plot.getDataView(), 0L, Long.MAX_VALUE, false)));
        this.plot.initializeTracks();
    }

    public DataSource createReadDataSource(DataFile data, DataFile indexData, List<TrackDefinition> tracks) throws IOException, URISyntaxException, GBrowserException {
        DataSource dataSource = null;
        File file = data == null ? null : data.getLocalFile();
        URL fileUrl = file.toURI().toURL();
        if (data.getName().contains(".bam-summary")) {
            dataSource = new TabixSummaryDataSource(fileUrl);
        } else if (data.getName().contains(".bam") || data.getName().contains(".sam")) {
            File indexFile = indexData.getLocalFile();
            URL indexFileUrl = indexFile.toURI().toURL();
            dataSource = new SAMDataSource(fileUrl, indexFileUrl);
        } else {
            dataSource = new ChunkDataSource(fileUrl, new ElandParser(), ChunkTreeHandlerThread.class);
        }
        return dataSource;
    }

    public URL getAnnotationUrl(AnnotationManager.Genome genome, AnnotationManager.AnnotationType type) {
        AnnotationManager.GenomeAnnotation annotation = this.annotationManager.getAnnotation(genome, type);
        if (annotation != null) {
            return annotation.getUrl();
        }
        return null;
    }

    public void showVisualisation() {
        if (this.plot != null) {
            this.plot.clean();
        }
        TooltipAugmentedChartPanel chartPanel = new TooltipAugmentedChartPanel();
        this.plot = new GBrowserPlot(chartPanel, true);
        this.plot.addDataRegionListener(this.settings);
        chartPanel.setPlot(this.plot);
        this.plot.getDataView().setBpRegion(new RegionDouble((double)this.settings.getLocation().longValue() - (double)this.settings.getViewSize().longValue() / 2.0, (double)this.settings.getLocation().longValue() + (double)this.settings.getViewSize().longValue() / 2.0, this.settings.getChromosome()), true);
        this.updateCoverageScale();
        this.updateTracks();
        this.settings.updateTracks();
        chartPanel.setChart(new JFreeChart((Plot)this.plot));
        chartPanel.setCursor(new Cursor(12));
        for (GBrowserView view : this.plot.getViews()) {
            chartPanel.addMouseListener(view);
            chartPanel.addMouseMotionListener(view);
            chartPanel.addMouseWheelListener(view);
        }
        if (this.plotPanel.getComponentCount() == 2) {
            this.plotPanel.remove(1);
        }
        this.setFullHeight(this.settings.isFullHeight());
        this.plotPanel.add((Component)((Object)chartPanel), PLOTPANEL);
        this.plotPanel.addComponentListener(this);
        CardLayout cl = (CardLayout)this.plotPanel.getLayout();
        cl.show(this.plotPanel, PLOTPANEL);
    }

    private GeneIndexActions getGeneIndexActions() {
        if (this.gia == null) {
            AnnotationManager.Genome genome = this.getGenome();
            try {
                URL gtfUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.GTF_TABIX).getUrl();
                URL gtfIndexUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.GTF_TABIX_INDEX).getUrl();
                URL geneUrl = this.annotationManager.getAnnotation(genome, AnnotationManager.AnnotationType.GENE_CHRS).getUrl();
                TabixDataSource gtfDataSource = new TabixDataSource(gtfUrl, gtfIndexUrl, GtfTabixHandlerThread.class);
                LineDataSource geneDataSource = new LineDataSource(geneUrl, GeneSearchHandler.class);
                this.gia = new GeneIndexActions(this.plot.getDataView().getQueueManager(), gtfDataSource, geneDataSource);
            }
            catch (Exception e) {
                this.reportException(e);
            }
        }
        return this.gia;
    }

    public void requestGeneSearch(String gene) {
        this.runBlockingTask("searching gene", new Runnable(){

            @Override
            public void run() {
                int TIME_OUT = 30000;
                int INTERVAL = 100;
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() < startTime + (long)TIME_OUT && !GBrowser.this.geneSearchDone) {
                    try {
                        Thread.sleep(INTERVAL);
                    }
                    catch (InterruptedException e) {}
                }
                if (GBrowser.this.geneSearchDone) {
                    GBrowser.this.geneSearchDone = false;
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GBrowser.this.showDialog("Search failed", "Unexpected error happened in the search. Please inform the developers if the problem persists.", null, true, false, false);
                        }
                    });
                }
            }
        });
        this.getGeneIndexActions().requestLocation(gene, new GeneIndexActions.GeneLocationListener(){

            @Override
            public void geneLocation(Region geneLocation) {
                GBrowser.this.geneSearchDone = true;
                if (geneLocation == null) {
                    GBrowser.this.settings.processLocationPanelInput();
                    GBrowser.this.showDialog("Not found", "Gene was not found", null, false, false, false);
                } else {
                    Chromosome resultChr = new Chromosome(geneLocation.start.chr);
                    if (GBrowser.this.settings.setChromosome(resultChr)) {
                        GBrowser.this.setLocation(GBrowser.this.settings.getChromosome(), geneLocation.start.bp, geneLocation.end.bp);
                    } else {
                        GBrowser.this.showDialog("Different chromosome", "Searched gene was found from chromosome " + resultChr + " but there is no data for that chromosome", "" + geneLocation, true, false, false);
                    }
                }
            }
        });
    }

    public void setLocation(Chromosome chr, Long start, Long end) {
        this.settings.setChromosome(chr);
        if (end == null) {
            end = start;
        }
        this.settings.setCoordinateFields((end + start) / 2L, (end - start) * 2L);
        this.plot.moveDataBpRegion(this.settings.getChromosome(), this.settings.getLocation(), this.settings.getViewSize());
        this.plot.setReadScale(this.settings.getCoverageScale());
    }

    public void removeVisualisation() {
        this.plotPanel.removeComponentListener(this);
        this.plotPanel.removeAll();
        if (this.plot != null) {
            this.plot.clean();
            this.plot = null;
        }
        if (this.tracks != null) {
            this.tracks.clear();
        }
        this.gia = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<Chromosome> getChromosomeNames() throws IOException {
        TreeSet<String> chromosomeNames = new TreeSet<String>();
        for (Interpretation interpretation : this.interpretations) {
            if (interpretation.type != TrackType.READS) continue;
            InputStream in = null;
            try {
                in = interpretation.primaryData.getInputStream();
                chromosomeNames.addAll(SamBamUtils.readChromosomeNames(in));
            }
            finally {
                IOUtils.closeIfPossible(in);
            }
        }
        if (chromosomeNames.isEmpty()) {
            for (Interpretation interpretation : this.getInterpretations()) {
                if (interpretation.type != TrackType.REGIONS) continue;
                DataFile data = interpretation.primaryData;
                File file = data.getLocalFile();
                List<RegionContent> rows = null;
                try {
                    rows = new RegionOperations().loadFile(file);
                    for (RegionContent row : rows) {
                        chromosomeNames.add(row.region.start.chr.toNormalisedString());
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        LinkedList<Chromosome> chromosomes = new LinkedList<Chromosome>();
        for (String chromosomeName : chromosomeNames) {
            chromosomes.add(new Chromosome(chromosomeName));
        }
        Collections.sort(chromosomes);
        return chromosomes;
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.plot.redraw();
    }

    public List<Interpretation> getInterpretations() {
        return this.interpretations;
    }

    public String getExternalLinkUrl(AnnotationManager.AnnotationType browser) {
        this.settings.getGenome();
        URL url = this.annotationManager.getAnnotation(this.settings.getGenome(), browser).getUrl();
        if (url != null && this.plot != null && this.plot.getDataView() != null && this.plot.getDataView().getBpRegion() != null) {
            String stringUrl = url.toString();
            Region region = this.plot.getDataView().getBpRegion();
            stringUrl = stringUrl.replace("[CHR]", region.start.chr.toNormalisedString());
            stringUrl = stringUrl.replace("[START]", region.start.bp.toString());
            stringUrl = stringUrl.replace("[END]", region.end.bp.toString());
            return stringUrl;
        }
        return "";
    }

    public void openExternalBrowser(String url) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    public JPanel getParameterPanel() {
        return this.settings.getParameterPanel();
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public List<TrackDefinition> getTracks() {
        return this.tracks;
    }

    public void reportException(Exception e) {
        e.printStackTrace();
    }

    public void showDialog(String title, String message, String details, boolean warning, boolean dialogShowDetails, boolean modal) {
        System.out.println("showDialog not implemented: " + title + "\t" + message + "\t" + details);
    }

    public void runBlockingTask(String taskName, Runnable runnable) {
        System.out.println("runBlockingTask: " + taskName);
        new Thread(runnable).start();
    }

    public void initialiseUserDatas() throws IOException {
    }

    public ImageIcon getIcon(String path) {
        System.out.println("getIcon not implemented");
        return new ImageIcon();
    }

    public void openDownloadAnnotationsDialog(AnnotationManager.Genome genome) {
        try {
            this.getAnnotationManager().downloadAnnotations(genome);
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    public URL getRemoteAnnotationsUrl() throws Exception {
        System.out.println("getRemoteAnnotationsUrl not implemented");
        return null;
    }

    public File getLocalAnnotationDir() throws IOException {
        System.out.println("getLocalAnnotationDir not implemented");
        return null;
    }

    public void updateData() {
        this.updateTracks();
        this.settings.updateVisibilityForTracks();
        this.plot.updateData();
    }

    public static class TrackDefinition {
        public Interpretation interpretation;
        public JCheckBox checkBox;
        public String name;
        public TrackGroup trackGroup = null;

        public TrackDefinition(String name, Interpretation interpretation) {
            this.name = name;
            this.interpretation = interpretation;
        }

        public void setTrackGroup(TrackGroup trackGroup) {
            this.trackGroup = trackGroup;
        }
    }

    public static class Interpretation {
        private TrackType type;
        private List<DataFile> summaryDatas = new LinkedList<DataFile>();
        private DataFile primaryData;
        private DataFile indexData;

        public Interpretation(TrackType type, DataFile primaryData) {
            this.type = type;
            this.primaryData = primaryData;
        }

        public TrackType getType() {
            return this.type;
        }

        public void setType(TrackType type) {
            this.type = type;
        }

        public List<DataFile> getSummaryDatas() {
            return this.summaryDatas;
        }

        public void setSummaryDatas(List<DataFile> summaryDatas) {
            this.summaryDatas = summaryDatas;
        }

        public DataFile getPrimaryData() {
            return this.primaryData;
        }

        public void setPrimaryData(DataFile primaryData) {
            this.primaryData = primaryData;
        }

        public DataFile getIndexData() {
            return this.indexData;
        }

        public void setIndexData(DataFile indexData) {
            this.indexData = indexData;
        }
    }

    public static class DataFile {
        private File file;

        public DataFile(File data) {
            this.file = data;
        }

        public String getName() {
            return this.file.getName();
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public File getLocalFile() throws IOException {
            return this.file;
        }
    }

    public static enum TrackType {
        CYTOBANDS(false),
        GENES(false),
        TRANSCRIPTS(true),
        REFERENCE(true),
        REGIONS(true),
        REGIONS_WITH_HEADER(true),
        READS(true),
        HIDDEN(false),
        VCF(true);

        public boolean isToggleable;

        private TrackType(boolean toggleable) {
            this.isToggleable = toggleable;
        }
    }
}

