/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

public class CamelContextFactory
implements BundleContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelContextFactory.class);
    private BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using BundleContext: " + bundleContext));
        }
        this.bundleContext = bundleContext;
    }

    protected DefaultCamelContext newCamelContext() {
        return new OsgiDefaultCamelContext(this.bundleContext);
    }

    public DefaultCamelContext createContext() {
        LOG.debug((Object)"Creating DefaultCamelContext");
        return this.newCamelContext();
    }
}

