/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import javax.swing.event.ChangeEvent;
import org.jfree.chart.plot.StandardHCClusteringInfo;
import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.DataRangeMismatchException;
import org.jfree.data.hc.HCTreeNode;

public class HCTreeNodeInfo {
    private boolean open;
    private HCTreeNode node;
    private HCTreeNodeInfo parent;
    private HCTreeNodeInfo leftChild;
    private HCTreeNodeInfo rightChild;
    private DataRange visibleDataRange;
    private StandardHCClusteringInfo clusteringInfo;

    public HCTreeNodeInfo(StandardHCClusteringInfo clusteringInfo, HCTreeNode node) {
        if (node == null) {
            throw new NullPointerException("A HCTreeNodeInfo object must have a non-null HCTreeNode.");
        }
        if (clusteringInfo == null) {
            throw new NullPointerException("A HCTreeNodeInfo object must have a non-null clustering info.");
        }
        this.open = false;
        this.node = node;
        this.parent = null;
        this.clusteringInfo = clusteringInfo;
        this.visibleDataRange = new DataRange(0, 0);
        if (node.getLeftChild() == null) {
            this.leftChild = null;
        } else {
            this.leftChild = new HCTreeNodeInfo(clusteringInfo, node.getLeftChild());
            this.leftChild.setParent(this);
            this.open = true;
        }
        if (node.getRightChild() == null) {
            this.rightChild = null;
        } else {
            this.rightChild = new HCTreeNodeInfo(clusteringInfo, node.getRightChild());
            this.rightChild.setParent(this);
            this.open = true;
        }
    }

    public void setNodeOpen(boolean open) {
        if (this.leftChild != null && this.rightChild != null) {
            this.open = open;
            this.updateVisibleDataRange();
            this.clusteringInfo.notifyChangeListeners(new ChangeEvent(this));
        }
    }

    private void setSubTreeOpenRecursively(boolean open) {
        if (this.leftChild != null && this.rightChild != null) {
            this.leftChild.setSubTreeOpenRecursively(open);
            this.rightChild.setSubTreeOpenRecursively(open);
            this.open = open;
        }
    }

    public void setSubTreeOpen(boolean open) {
        if (this.leftChild != null && this.rightChild != null) {
            this.setSubTreeOpenRecursively(open);
            this.updateVisibleDataRange();
            this.clusteringInfo.notifyChangeListeners(new ChangeEvent(this));
        }
    }

    public boolean isNodeOpen() {
        return this.open;
    }

    public HCTreeNode getNode() {
        return this.node;
    }

    public HCTreeNodeInfo getLeftChild() {
        return this.leftChild;
    }

    public HCTreeNodeInfo getRightChild() {
        return this.rightChild;
    }

    public HCTreeNodeInfo getParent() {
        return this.parent;
    }

    public void setParent(HCTreeNodeInfo node) {
        if (this.parent != null && this.parent.getLeftChild() != this && this.parent.getRightChild() != this) {
            throw new IllegalArgumentException("A HCTreeNodeInfo object can only be set as a parent of another object, if that node is already its child.");
        }
        if (this.parent != null) {
            throw new IllegalArgumentException("You cannot set a parent for a HCTreeNodeInfo node that already has one.");
        }
        this.parent = node;
    }

    public String toString() {
        return this.clusteringInfo.getName(this.getNode().getDataRange());
    }

    public StandardHCClusteringInfo getClusteringInfo() {
        return this.clusteringInfo;
    }

    public DataRange getVisibleDataRange() {
        return this.visibleDataRange;
    }

    public HCTreeNodeInfo getNodeByNode(HCTreeNode node) {
        DataRange dr = node.getDataRange();
        if (dr.equals(this.getNode().getDataRange())) {
            return this;
        }
        if (this.getLeftChild() != null && this.getLeftChild().getNode().getDataRange().contains(dr)) {
            return this.getLeftChild().getNodeByNode(node);
        }
        if (this.getRightChild() != null && this.getRightChild().getNode().getDataRange().contains(dr)) {
            return this.getRightChild().getNodeByNode(node);
        }
        throw new IndexOutOfBoundsException();
    }

    public HCTreeNodeInfo getNodeByIndex(int index) {
        if (this.leftChild != null && this.leftChild.getNode().getDataRange().contains(index)) {
            return this.leftChild.getNodeByIndex(index);
        }
        if (this.rightChild != null && this.rightChild.getNode().getDataRange().contains(index)) {
            return this.rightChild.getNodeByIndex(index);
        }
        if (this.getNode().getDataRange().equals(new DataRange(index, index))) {
            return this;
        }
        throw new IndexOutOfBoundsException("There is no node " + index + "under this node.");
    }

    public HCTreeNodeInfo getNodeByVisibleIndex(int index) {
        if (this.leftChild != null && this.leftChild.getVisibleDataRange().contains(index) && this.open) {
            return this.leftChild.getNodeByVisibleIndex(index);
        }
        if (this.rightChild != null && this.rightChild.getVisibleDataRange().contains(index) && this.open) {
            return this.rightChild.getNodeByVisibleIndex(index);
        }
        if (this.visibleDataRange.equals(new DataRange(index, index))) {
            return this;
        }
        throw new IndexOutOfBoundsException("There is no visible node " + index + "under this node.");
    }

    private int updateVisibleDataRange(int index) {
        if (this.leftChild == null || this.rightChild == null || !this.open) {
            this.visibleDataRange = new DataRange(index, index);
            return index + 1;
        }
        index = this.getLeftChild().updateVisibleDataRange(index);
        index = this.getRightChild().updateVisibleDataRange(index);
        this.visibleDataRange = (DataRange)this.getLeftChild().getVisibleDataRange().clone();
        try {
            this.visibleDataRange.add(this.getRightChild().getVisibleDataRange());
        }
        catch (DataRangeMismatchException dataRangeMismatchException) {
            // empty catch block
        }
        return index;
    }

    public void updateVisibleDataRange() {
        this.clusteringInfo.getRootNode().updateVisibleDataRange(0);
    }
}

