/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.ArrayList;
import java.util.Random;
import net.sf.picard.sam.MultiHitAlignedReadIterator;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;

public class BestMapqPrimaryAlignmentSelectionStrategy
implements PrimaryAlignmentSelectionStrategy {
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(MultiHitAlignedReadIterator.HitsForInsert hits) {
        int primaryAlignmentIndex;
        if (hits.numHits() == 0) {
            throw new IllegalArgumentException("No alignments to pick from");
        }
        ArrayList<Integer> primaryAlignmentIndices = new ArrayList<Integer>(hits.numHits());
        int bestMapQ = -1;
        for (int i = 0; i < hits.numHits(); ++i) {
            int thisMapQ = 0;
            if (hits.getFirstOfPair(i) != null) {
                thisMapQ += hits.getFirstOfPair(i).getMappingQuality();
            }
            if (hits.getSecondOfPair(i) != null) {
                thisMapQ += hits.getSecondOfPair(i).getMappingQuality();
            }
            if (thisMapQ > bestMapQ) {
                bestMapQ = thisMapQ;
                primaryAlignmentIndices.clear();
            }
            if (thisMapQ != bestMapQ) continue;
            primaryAlignmentIndices.add(i);
        }
        if (primaryAlignmentIndices.size() == 1) {
            primaryAlignmentIndex = (Integer)primaryAlignmentIndices.get(0);
        } else if (primaryAlignmentIndices.size() > 1) {
            primaryAlignmentIndex = (Integer)primaryAlignmentIndices.get(this.random.nextInt(primaryAlignmentIndices.size()));
        } else {
            throw new IllegalStateException("Never found a best MAPQ -- should never happen");
        }
        hits.setPrimaryAlignment(primaryAlignmentIndex);
    }
}

