/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapNetworkConnector
extends NetworkConnector
implements NamespaceChangeListener,
ObjectChangeListener {
    private static final Log LOG = LogFactory.getLog(LdapNetworkConnector.class);
    private static final String REQUIRED_OBJECT_CLASS_FILTER = "(&(objectClass=ipHost)(objectClass=ipService))";
    private URI[] availableURIs = null;
    private int availableURIsIndex = 0;
    private String base = null;
    private boolean failover = false;
    private long curReconnectDelay = 1000L;
    private long maxReconnectDelay = 30000L;
    private String user = null;
    private String password = null;
    private boolean anonymousAuthentication = false;
    private SearchControls searchControls = new SearchControls();
    private String searchFilter = "(&(objectClass=ipHost)(objectClass=ipService))";
    private boolean searchEventListener = false;
    private Map<URI, NetworkConnector> connectorMap = new ConcurrentHashMap<URI, NetworkConnector>();
    private Map<URI, Integer> referenceMap = new ConcurrentHashMap<URI, Integer>();
    private Map<String, URI> uuidMap = new ConcurrentHashMap<String, URI>();
    private DirContext context = null;
    private URI ldapURI = null;

    public URI getUri() {
        return this.availableURIs[++this.availableURIsIndex % this.availableURIs.length];
    }

    public void setUri(URI _uri) throws Exception {
        URISupport.CompositeData data = URISupport.parseComposite(_uri);
        if (data.getScheme().equals("failover")) {
            this.availableURIs = data.getComponents();
            this.failover = true;
        } else {
            this.availableURIs = new URI[]{_uri};
        }
    }

    public void setBase(String _base) {
        this.base = _base;
    }

    public void setUser(String _user) {
        this.user = _user;
    }

    public void setPassword(String _password) {
        this.password = _password;
    }

    public void setAnonymousAuthentication(boolean _anonymousAuthentication) {
        this.anonymousAuthentication = _anonymousAuthentication;
    }

    public void setSearchScope(String _searchScope) throws Exception {
        int scope;
        if (_searchScope.equals("OBJECT_SCOPE")) {
            scope = 0;
        } else if (_searchScope.equals("ONELEVEL_SCOPE")) {
            scope = 1;
        } else if (_searchScope.equals("SUBTREE_SCOPE")) {
            scope = 2;
        } else {
            throw new Exception("ERR: unknown LDAP search scope specified: " + _searchScope);
        }
        this.searchControls.setSearchScope(scope);
    }

    public void setSearchFilter(String _searchFilter) {
        this.searchFilter = "(&(&(objectClass=ipHost)(objectClass=ipService))(" + _searchFilter + "))";
    }

    public void setSearchEventListener(boolean _searchEventListener) {
        this.searchEventListener = _searchEventListener;
    }

    public void start() throws Exception {
        LOG.info((Object)"connecting...");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.ldapURI = this.getUri();
        LOG.debug((Object)("    URI [" + this.ldapURI + "]"));
        env.put("java.naming.provider.url", this.ldapURI.toString());
        if (this.anonymousAuthentication) {
            LOG.debug((Object)"    login credentials [anonymous]");
            env.put("java.naming.security.authentication", "none");
        } else {
            LOG.debug((Object)("    login credentials [" + this.user + ":******]"));
            env.put("java.naming.security.principal", this.user);
            env.put("java.naming.security.credentials", this.password);
        }
        boolean isConnected = false;
        while (!isConnected) {
            try {
                this.context = new InitialDirContext(env);
                isConnected = true;
            }
            catch (CommunicationException err) {
                if (this.failover) {
                    this.ldapURI = this.getUri();
                    LOG.error((Object)("connection error [" + (String)env.get("java.naming.provider.url") + "], failover connection to [" + this.ldapURI.toString() + "]"));
                    env.put("java.naming.provider.url", this.ldapURI.toString());
                    Thread.sleep(this.curReconnectDelay);
                    this.curReconnectDelay = Math.min(this.curReconnectDelay * 2L, this.maxReconnectDelay);
                    continue;
                }
                throw err;
            }
        }
        LOG.info((Object)"searching for network connectors...");
        LOG.debug((Object)("    base   [" + this.base + "]"));
        LOG.debug((Object)("    filter [" + this.searchFilter + "]"));
        LOG.debug((Object)("    scope  [" + this.searchControls.getSearchScope() + "]"));
        NamingEnumeration<SearchResult> results = this.context.search(this.base, this.searchFilter, this.searchControls);
        while (results.hasMore()) {
            this.addConnector(results.next());
        }
        if (this.searchEventListener) {
            LOG.info((Object)"registering persistent search listener...");
            EventDirContext eventContext = (EventDirContext)this.context.lookup("");
            eventContext.addNamingListener(this.base, this.searchFilter, this.searchControls, (NamingListener)this);
        } else {
            this.context.close();
        }
    }

    public void stop() throws Exception {
        LOG.info((Object)"stopping context...");
        for (NetworkConnector connector : this.connectorMap.values()) {
            connector.stop();
        }
        this.connectorMap.clear();
        this.referenceMap.clear();
        this.uuidMap.clear();
        this.context.close();
    }

    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = this.getClass().getName() + " [" + this.ldapURI.toString() + "]";
            super.setName(name);
        }
        return name;
    }

    protected synchronized void addConnector(SearchResult result) throws Exception {
        String uuid = this.toUUID(result);
        if (this.uuidMap.containsKey(uuid)) {
            LOG.warn((Object)("connector already regsitered for UUID [" + uuid + "]"));
            return;
        }
        URI connectorURI = this.toURI(result);
        if (this.connectorMap.containsKey(connectorURI)) {
            int referenceCount = this.referenceMap.get(connectorURI) + 1;
            LOG.warn((Object)("connector reference added for URI [" + connectorURI + "], UUID [" + uuid + "], total reference(s) [" + referenceCount + "]"));
            this.referenceMap.put(connectorURI, referenceCount);
            this.uuidMap.put(uuid, connectorURI);
            return;
        }
        NetworkConnector connector = this.getBrokerService().addNetworkConnector(connectorURI);
        connector.setDynamicOnly(this.isDynamicOnly());
        connector.setDecreaseNetworkConsumerPriority(this.isDecreaseNetworkConsumerPriority());
        connector.setNetworkTTL(this.getNetworkTTL());
        connector.setConduitSubscriptions(this.isConduitSubscriptions());
        connector.setExcludedDestinations(this.getExcludedDestinations());
        connector.setDynamicallyIncludedDestinations(this.getDynamicallyIncludedDestinations());
        connector.setDuplex(this.isDuplex());
        connector.setLocalUri(this.getBrokerService().getVmConnectorURI());
        connector.setBrokerName(this.getBrokerService().getBrokerName());
        connector.setDurableDestinations(this.getBrokerService().getBroker().getDurableDestinations());
        this.connectorMap.put(connectorURI, connector);
        this.referenceMap.put(connectorURI, 1);
        this.uuidMap.put(uuid, connectorURI);
        connector.start();
        LOG.info((Object)("connector added with URI [" + connectorURI + "]"));
    }

    protected synchronized void removeConnector(SearchResult result) throws Exception {
        String uuid = this.toUUID(result);
        if (!this.uuidMap.containsKey(uuid)) {
            LOG.warn((Object)("connector not regsitered for UUID [" + uuid + "]"));
            return;
        }
        URI connectorURI = this.uuidMap.get(uuid);
        if (!this.connectorMap.containsKey(connectorURI)) {
            LOG.warn((Object)("connector not regisitered for URI [" + connectorURI + "]"));
            return;
        }
        int referenceCount = this.referenceMap.get(connectorURI) - 1;
        this.referenceMap.put(connectorURI, referenceCount);
        this.uuidMap.remove(uuid);
        LOG.debug((Object)("connector referenced removed for URI [" + connectorURI + "], UUID [" + uuid + "], remaining reference(s) [" + referenceCount + "]"));
        if (referenceCount > 0) {
            return;
        }
        NetworkConnector connector = this.connectorMap.remove(connectorURI);
        connector.stop();
        LOG.info((Object)("connector removed with URI [" + connectorURI + "]"));
    }

    protected URI toURI(SearchResult result) throws Exception {
        Attributes attributes = result.getAttributes();
        String address = (String)attributes.get("iphostnumber").get();
        String port = (String)attributes.get("ipserviceport").get();
        String protocol = (String)attributes.get("ipserviceprotocol").get();
        URI connectorURI = new URI("static:(" + protocol + "://" + address + ":" + port + ")");
        LOG.debug((Object)("retrieved URI from SearchResult [" + connectorURI + "]"));
        return connectorURI;
    }

    protected String toUUID(SearchResult result) {
        String uuid = result.getNameInNamespace();
        LOG.debug((Object)("retrieved UUID from SearchResult [" + uuid + "]"));
        return uuid;
    }

    public void objectAdded(NamingEvent event) {
        LOG.debug((Object)"entry added");
        try {
            this.addConnector((SearchResult)event.getNewBinding());
        }
        catch (Exception err) {
            LOG.error((Object)"ERR: caught unexpected exception", (Throwable)err);
        }
    }

    public void objectRemoved(NamingEvent event) {
        LOG.debug((Object)"entry removed");
        try {
            this.removeConnector((SearchResult)event.getOldBinding());
        }
        catch (Exception err) {
            LOG.error((Object)"ERR: caught unexpected exception", (Throwable)err);
        }
    }

    public void objectRenamed(NamingEvent event) {
        LOG.debug((Object)"entry renamed");
        String uuidOld = event.getOldBinding().getName();
        String uuidNew = event.getNewBinding().getName();
        URI connectorURI = this.uuidMap.remove(uuidOld);
        this.uuidMap.put(uuidNew, connectorURI);
        LOG.debug((Object)("connector reference renamed for URI [" + connectorURI + "], Old UUID [" + uuidOld + "], New UUID [" + uuidNew + "]"));
    }

    public void objectChanged(NamingEvent event) {
        LOG.debug((Object)"entry changed");
        try {
            SearchResult result = (SearchResult)event.getNewBinding();
            this.removeConnector(result);
            this.addConnector(result);
        }
        catch (Exception err) {
            LOG.error((Object)"ERR: caught unexpected exception", (Throwable)err);
        }
    }

    public void namingExceptionThrown(NamingExceptionEvent event) {
        LOG.error((Object)"ERR: caught unexpected exception", (Throwable)event.getException());
    }
}

