/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.processor.DelegateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncProcessorTypeConverter
implements TypeConverter {
    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        if (value != null && type.equals(AsyncProcessor.class)) {
            if (value instanceof AsyncProcessor) {
                return type.cast(value);
            }
            if (value instanceof Processor) {
                Processor processor = (Processor)value;
                return type.cast(new ProcessorToAsyncProcessorBridge(processor));
            }
        }
        return null;
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return this.convertTo(type, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.convertTo(type, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        return this.convertTo(type, exchange, value);
    }

    public static AsyncProcessor convert(Processor value) {
        if (value instanceof AsyncProcessor) {
            return (AsyncProcessor)value;
        }
        return new ProcessorToAsyncProcessorBridge(value);
    }

    private static final class ProcessorToAsyncProcessorBridge
    extends DelegateProcessor
    implements AsyncProcessor {
        private ProcessorToAsyncProcessorBridge(Processor processor) {
            super(processor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(Exchange exchange, AsyncCallback callback) {
            if (this.processor == null) {
                callback.done(true);
                return true;
            }
            try {
                this.processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            finally {
                callback.done(true);
            }
            return true;
        }

        public String toString() {
            if (this.processor != null) {
                return this.processor.toString();
            }
            return "Processor is null";
        }
    }
}

