/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.component.file.FileBinding;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConsumer
extends GenericFileConsumer<File> {
    private String endpointPath;

    public FileConsumer(GenericFileEndpoint<File> endpoint, Processor processor, GenericFileOperations<File> operations) {
        super(endpoint, processor, operations);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    @Override
    protected boolean pollDirectory(String fileName, List<GenericFile<File>> fileList) {
        File[] files;
        File directory;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("pollDirectory from fileName: " + fileName));
        }
        if (!(directory = new File(fileName)).exists() || !directory.isDirectory()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot poll as directory does not exists or its not a directory: " + directory));
            }
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling directory: " + directory.getPath()));
        }
        if ((files = directory.listFiles()) == null || files.length == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("No files found in directory: " + directory.getPath()));
            }
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Found " + files.length + " in directory: " + directory.getPath()));
        }
        for (File file : files) {
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Found file: " + file + " [isAbsolute: " + file.isAbsolute() + ", isDirectory: " + file.isDirectory() + ", isFile: " + file.isFile() + ", isHidden: " + file.isHidden() + "]"));
            }
            GenericFile<File> gf = FileConsumer.asGenericFile(this.endpointPath, file);
            if (file.isDirectory()) {
                String subDirectory;
                boolean canPollMore;
                if (!this.endpoint.isRecursive() || !this.isValidFile(gf, true) || (canPollMore = this.pollDirectory(subDirectory = fileName + File.separator + file.getName(), fileList))) continue;
                return false;
            }
            if (!this.isValidFile(gf, false)) continue;
            if (this.isInProgress(gf)) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("Skipping as file is already in progress: " + gf.getFileName()));
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Adding valid file: " + file));
            }
            fileList.add(gf);
        }
        return true;
    }

    public static GenericFile<File> asGenericFile(String endpointPath, File file) {
        GenericFile<File> answer = new GenericFile<File>();
        answer.setBinding(new FileBinding());
        answer.setEndpointPath(endpointPath);
        answer.setFile(file);
        answer.setFileName(file.getName());
        answer.setFileNameOnly(file.getName());
        answer.setFileLength(file.length());
        answer.setAbsolute(FileUtil.isAbsolute(file));
        answer.setAbsoluteFilePath(file.getAbsolutePath());
        answer.setLastModified(file.lastModified());
        if (answer.isAbsolute()) {
            answer.setRelativeFilePath(file.getAbsolutePath());
        } else {
            String endpointNormalized = FileUtil.normalizePath(endpointPath);
            File path = file.getPath().startsWith(endpointNormalized) ? new File(ObjectHelper.after(file.getPath(), endpointNormalized + File.separator)) : new File(file.getPath());
            if (path.getParent() != null) {
                answer.setRelativeFilePath(path.getParent() + File.separator + file.getName());
            } else {
                answer.setRelativeFilePath(path.getName());
            }
        }
        answer.setBody(file);
        return answer;
    }
}

