/* =======================================================================
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 *  This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 */

package org.jfree.chart.entity;

import org.jfree.chart.entity.ChartEntity;
import org.jfree.data.som.*;

import java.awt.Shape;

/**
 * A chart entity that represents one item in a
 * {@link org.jfree.chart.plot.SOMPlot}.
 * @author viski project, Univ. Helsinki
 */
public class SOMItemEntity extends ChartEntity {
    
    /** The dataset. */
    protected SOMDataset dataset;
    /** The x coordinate in the SOM map. */
    protected int x;
    /** The y coordinate in the SOM map. */
    protected int y;
    
    /** 
     * Creates a new entity. 
     * 
     * @param area  the area.
     * @param dataset  the dataset. Null value not allowed.
     * @param x  the x coordinate. Must be non-negative.
     * @param y  the y coordinate. Must be non-negative.
     * @param toolTipText  the tool tip text. Null allowed.
     * @param urlText  the URL text for HTML imagemaps. Null allowed.
     * @throws IllegalArgumentException If dataset == null or x < 0 or y < 0.
     */
    public SOMItemEntity(Shape area, 
                         SOMDataset dataset,
                         int x, int y, 
                         String toolTipText, 
                         String urlText) {
        super(area, toolTipText, urlText);
        if (dataset == null)
            throw new IllegalArgumentException("dataset was null");
        if (x < 0)
            throw new IllegalArgumentException("x was negative");
        if (y < 0)
            throw new IllegalArgumentException("y was negative");
        this.dataset = dataset;
        this.x = x;
        this.y = y;
    }

    /**
     * Returns the dataset this entity refers to.
     *
     * @return  The dataset.
     */
    public SOMDataset getDataset() {
        return this.dataset;
    }

    /**
     * Sets the dataset this entity refers to.
     *
     * @param dataset The dataset (null permitted.)
     */
    public void setDataset(SOMDataset dataset) {
        this.dataset = dataset;
    }

    /**
     * Returns the x coordinate of this entity.
     *
     * @return  The x coordinate.
     */
    public int getX() {
        return this.x;
    }

    /**
     * Returns the y coordinate of this entity.
     *
     * @return  The y coordinate.
     */
    public int getY() {
        return this.y;
    }

}
