/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.util.ImageUtil;

public class ImageReplacedElement
implements ReplacedElement {
    private final Image _image;
    private Point _location = new Point(0, 0);

    public ImageReplacedElement(Image image, int targetWidth, int targetHeight) {
        if (targetWidth > 0 || targetHeight > 0) {
            int newH;
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            int newW = targetWidth > 0 ? targetWidth : w;
            int n = newH = targetHeight > 0 ? targetHeight : h;
            if (w != newW || h != newH) {
                image = image instanceof BufferedImage ? ImageUtil.getScaledInstance((BufferedImage)image, newW, newH) : image.getScaledInstance(newW, newH, 2);
            }
        }
        this._image = image;
    }

    public void detach(LayoutContext c) {
    }

    public int getIntrinsicHeight() {
        return this._image.getHeight(null);
    }

    public int getIntrinsicWidth() {
        return this._image.getWidth(null);
    }

    public Point getLocation() {
        return this._location;
    }

    public boolean isRequiresInteractivePaint() {
        return true;
    }

    public void setLocation(int x, int y) {
        this._location = new Point(x, y);
    }

    public Image getImage() {
        return this._image;
    }
}

