/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.CircularView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.HorizontalView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.OverviewHorizontalView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.EmptyTrack;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.general.DatasetChangeEvent;

public class GenomePlot
extends Plot {
    private List<View> views = new LinkedList<View>();
    private View dataView = null;
    private OverviewHorizontalView overviewView = null;
    private ReadScale readScale = ReadScale.AUTO;
    public TooltipAugmentedChartPanel chartPanel;
    private boolean showFullHeight = false;
    private Rectangle fullHeightClip;

    public GenomePlot(TooltipAugmentedChartPanel panel, boolean horizontal) {
        this.chartPanel = panel;
        this.chartPanel.setLayout(null);
        this.overviewView = new OverviewHorizontalView(this);
        this.overviewView.margin = 0;
        this.overviewView.setStaticHeight(true);
        this.overviewView.setStaticHeight(25);
        this.views.add(this.overviewView);
        if (horizontal) {
            this.dataView = new HorizontalView(this, true, true, false);
        } else {
            this.dataView = new CircularView(this, true, true, false);
            this.dataView.margin = 20;
            this.dataView.addTrack(new EmptyTrack(this.dataView, 30));
        }
        this.views.add(this.dataView);
        this.chartPanel.addTooltipRequestProcessor(this.dataView);
        this.dataView.addRegionListener(new RegionListener(){

            @Override
            public void regionChanged(Region bpRegion) {
                ((GenomePlot)GenomePlot.this).overviewView.highlight = bpRegion;
                GenomePlot.this.overviewView.setBpRegion(new RegionDouble(0.0, 2.5E8, bpRegion.start.chr), false);
            }
        });
        this.overviewView.addOverviewRegionListener(new RegionListener(){

            @Override
            public void regionChanged(Region bpRegion) {
                GenomePlot.this.dataView.setBpRegion(new RegionDouble(bpRegion), false);
            }
        });
    }

    public View getDataView() {
        return this.dataView;
    }

    public View getOverviewView() {
        return this.overviewView;
    }

    public void start(String chromosome, Double chromosomeSizeBp, Long position, Long length) {
        this.overviewView.setBpRegion(new RegionDouble(0.0, chromosomeSizeBp, new Chromosome(chromosome)), false);
        this.moveDataBpRegion(new Chromosome(chromosome), position, length);
    }

    public void moveDataBpRegion(Chromosome moveToChr, Long moveToBp, Long length) {
        RegionDouble bpCoordRegion = new RegionDouble(new Double(moveToBp - length / 2L), new Double(moveToBp + length / 2L), moveToChr);
        this.dataView.setBpRegion(bpCoordRegion, false);
    }

    public void addDataRegionListener(RegionListener regionListener) {
        this.dataView.addRegionListener(regionListener);
    }

    public String getPlotType() {
        return "GeneBrowser";
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(area);
            info.setDataArea(area);
        }
        Shape savedClip = g2.getClip();
        g2.clip(area);
        Rectangle viewArea = (Rectangle)area.getBounds().clone();
        Rectangle viewPort = (Rectangle)this.getFullHeightClip().clone();
        for (int i = 0; i < this.views.size(); ++i) {
            View view = this.views.get(i);
            if (i > 0) {
                viewArea.y += viewArea.height;
            }
            viewArea.height = view.hasStaticHeight() ? view.getStaticHeight() : (int)(area.getBounds().getHeight() - (double)this.getStaticViewHeight()) / this.getNonStaticViewCount();
            g2.setClip(viewArea);
            view.drawView(g2, false, viewPort);
        }
        g2.setClip(savedClip);
    }

    public int getHeight() {
        int total = 0;
        for (View view : this.views) {
            if (view.hasStaticHeight()) {
                total += view.getStaticHeight();
                continue;
            }
            total += view.getFullHeight();
        }
        return total;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof GenomePlot;
    }

    public void redraw() {
        this.datasetChanged(new DatasetChangeEvent((Object)this, null));
    }

    public Collection<View> getViews() {
        return this.views;
    }

    public ReadScale getReadScale() {
        return this.readScale;
    }

    public void setReadScale(ReadScale readScale) {
        this.readScale = readScale;
        this.dataView.redraw();
    }

    private int getStaticViewHeight() {
        int heightSum = 0;
        for (View view : this.views) {
            if (!view.hasStaticHeight()) continue;
            heightSum += view.getStaticHeight();
        }
        return heightSum;
    }

    private int getNonStaticViewCount() {
        int count = 0;
        for (View view : this.views) {
            if (view.hasStaticHeight()) continue;
            ++count;
        }
        return count;
    }

    public boolean isFullHeight() {
        return this.showFullHeight;
    }

    public void setFullHeight(boolean b) {
        this.showFullHeight = b;
    }

    public void clean() {
        this.chartPanel.removeTooltipRequestProcessor();
        this.overviewView.clean();
        this.dataView.clean();
        this.dataView = null;
    }

    public void setFullHeightClip(Rectangle clip) {
        this.fullHeightClip = clip;
    }

    public Rectangle getFullHeightClip() {
        return this.fullHeightClip;
    }

    public static enum ReadScale {
        XS("10", 10),
        SMALL("50", 50),
        MEDIUM("100", 100),
        MEDIUM2("250", 250),
        LARGE("500", 500),
        XL("1000", 1000),
        XXL("5000", 5000),
        XXXL("10000", 10000),
        AUTO("Automatic", 0);

        private String name;
        public Integer numReads;

        private ReadScale(String name, Integer numReads) {
            this.name = name;
            this.numReads = numReads;
        }

        public String toString() {
            return this.name;
        }
    }
}

