/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.EnumParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import fi.csc.microarray.client.operation.parameter.SingleSelectionInputComponent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class MultipleSelectionInputComponent
extends ParameterInputComponent
implements ActionListener {
    private static final Logger logger = Logger.getLogger(SingleSelectionInputComponent.class);
    EnumParameter param;
    List<JCheckBox> checkboxes = new LinkedList<JCheckBox>();
    JPanel checkboxPanel = new JPanel();

    protected MultipleSelectionInputComponent(EnumParameter param, ParameterPanel parameterPanel) {
        super(parameterPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.param = param;
        for (Object choice : param.getOptions()) {
            EnumParameter.SelectionOption option = (EnumParameter.SelectionOption)choice;
            boolean selected = false;
            if (param.getSelectedOptions().contains(option)) {
                selected = true;
            }
            JCheckBox checkbox = new JCheckBox(option.toString(), selected);
            checkbox.setName(option.getValue());
            checkbox.addActionListener(this);
            checkbox.addFocusListener(this);
            this.checkboxes.add(checkbox);
            this.add(checkbox);
        }
        this.getComponent(0);
    }

    public List<String> getSelectedNames() {
        LinkedList<String> selectionList = new LinkedList<String>();
        for (JCheckBox checkbox : this.checkboxes) {
            if (!checkbox.isSelected()) continue;
            selectionList.add(checkbox.getName());
        }
        return selectionList;
    }

    @Override
    public Parameter getParameter() {
        return this.param;
    }

    @Override
    public JComponent getParameterComponent() {
        return this;
    }

    @Override
    public boolean inputIsValid() {
        int count = this.getSelectedNames().size();
        return count >= this.param.getMaxCount() && count <= this.param.getMinCount();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.param.setValue(this.getSelectedNames());
        logger.debug((Object)("set selection to " + this.getSelectedNames()));
        this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
    }
}

