/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class CreateFromTextDialog
extends JDialog
implements CaretListener,
ActionListener {
    private final Dimension BUTTON_SIZE = new Dimension(70, 25);
    private JLabel nameLabel;
    private JLabel textLabel;
    private JTextField nameField;
    private JTextArea textArea;
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox folderNameCombo;
    private JCheckBox importCheckBox;

    public CreateFromTextDialog(ClientApplication clientApplication) {
        super((Frame)Session.getSession().getFrames().getMainFrame(), true);
        this.setTitle("Create dataset from text");
        this.setModal(true);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.nameLabel = new JLabel("Filename");
        c.anchor = 17;
        c.insets.set(10, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.nameLabel, c);
        this.nameField = new JTextField();
        this.nameField.setPreferredSize(new Dimension(150, 20));
        this.nameField.setText("data.txt");
        this.nameField.addCaretListener(this);
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.nameField, c);
        this.folderNameCombo = new JComboBox<Object>(ImportUtils.getFolderNames(true).toArray());
        this.folderNameCombo.setPreferredSize(new Dimension(150, 20));
        this.folderNameCombo.setEditable(true);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)new JLabel("Create in folder"), c);
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.folderNameCombo, c);
        this.textLabel = new JLabel("Text");
        c.anchor = 17;
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)this.textLabel, c);
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.setBorder(BorderFactory.createEmptyBorder());
        this.textArea.addCaretListener(this);
        JScrollPane areaScrollPane = new JScrollPane(this.textArea);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        areaScrollPane.setHorizontalScrollBarPolicy(30);
        areaScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        areaScrollPane.setPreferredSize(new Dimension(570, 300));
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)areaScrollPane, c);
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(this.BUTTON_SIZE);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton.addActionListener(this);
        this.importCheckBox = new JCheckBox("Import as plain text");
        this.importCheckBox.setSelected(true);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)this.importCheckBox, c);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        c.fill = 2;
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)buttonsPanel, c);
        this.pack();
        this.setResizable(false);
        Session.getSession().getFrames().setLocationRelativeToMainFrame(this);
        this.textArea.requestFocusInWindow();
        this.setVisible(true);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            String fileName = this.nameField.getText();
            String fileContent = this.textArea.getText();
            String folderName = (String)this.folderNameCombo.getSelectedItem();
            try {
                if (this.importCheckBox.isSelected()) {
                    ClientApplication application = Session.getSession().getApplication();
                    ByteArrayInputStream stream = new ByteArrayInputStream(fileContent.getBytes());
                    DataBean data = application.getDataManager().createDataBean(fileName, stream);
                    data.setContentType(application.getDataManager().guessContentType(fileName));
                    data.setOperationRecord(new OperationRecord(new Operation(OperationDefinition.IMPORT_DEFINITION, new DataBean[]{data})));
                    DataFolder folder = application.initializeFolderForImport(folderName);
                    folder.addChild(data);
                    application.getSelectionManager().selectSingle(data, this);
                } else {
                    File file = ImportUtils.createTempFile(fileName, ImportUtils.getExtension(fileName));
                    FileOutputStream fileStream = new FileOutputStream(file);
                    fileStream.write(fileContent.getBytes());
                    ImportSession importSession = new ImportSession(ImportSession.Source.CLIPBOARD, new File[]{file}, this.folderNameCombo.getSelectedItem().toString(), true);
                    ImportUtils.executeImport(importSession);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }
}

