/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.gbrowser;

import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class TsvToConstant {
    public static File convert(File in, File out, int[] fieldLengths) throws MicroarrayException {
        try {
            String line;
            BufferedWriter writer = new BufferedWriter(new FileWriter(out));
            BufferedReader reader = new BufferedReader(new FileReader(in));
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] cols = line.split("\t");
                StringBuilder constLine = new StringBuilder();
                for (int j = 0; j < fieldLengths.length; ++j) {
                    if (cols.length <= j) {
                        constLine.append(TsvToConstant.fillWithSpaces("", fieldLengths[j]));
                        continue;
                    }
                    try {
                        constLine.append(TsvToConstant.fillWithSpaces(cols[j], fieldLengths[j]));
                        continue;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new MicroarrayException("Error in converting to constant column length file: Column in input file is longer than defined column length. \nInput file: " + in.getName() + ", on row: " + i + ", column: " + j + "\n" + "Column content: " + cols[j] + ", defined length: " + fieldLengths[j]);
                    }
                }
                constLine.append("\n");
                writer.write(constLine.toString());
                ++i;
            }
            writer.flush();
            writer.close();
            reader.close();
            return out;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String fillWithSpaces(String orig, int length) {
        return orig + Strings.repeat(" ", length - orig.length());
    }

    public static void main(String[] args) throws MicroarrayException {
        File in = new File("/tmp/neppi/1.tsv");
        File out = new File("/tmp/neppi/out.txt");
        TsvToConstant.convert(in, out, new int[]{10, 15, 20});
    }
}

