/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.Endpoint;
import org.apache.activemq.command.Response;
import org.apache.activemq.state.CommandVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompFrame
implements Command {
    public static final byte[] NO_DATA = new byte[0];
    private String action;
    private Map<String, String> headers = new HashMap<String, String>();
    private byte[] content = NO_DATA;

    public StompFrame(String command) {
        this(command, null, null);
    }

    public StompFrame(String command, Map<String, String> headers) {
        this(command, headers, null);
    }

    public StompFrame(String command, Map<String, String> headers, byte[] data) {
        this.action = command;
        if (headers != null) {
            this.headers = headers;
        }
        if (data != null) {
            this.content = data;
        }
    }

    public StompFrame() {
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String command) {
        this.action = command;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getBody() {
        try {
            return new String(this.content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.content);
        }
    }

    public void setContent(byte[] data) {
        this.content = data;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public int getCommandId() {
        return 0;
    }

    @Override
    public Endpoint getFrom() {
        return null;
    }

    @Override
    public Endpoint getTo() {
        return null;
    }

    @Override
    public boolean isBrokerInfo() {
        return false;
    }

    @Override
    public boolean isMessage() {
        return false;
    }

    @Override
    public boolean isMessageAck() {
        return false;
    }

    @Override
    public boolean isMessageDispatch() {
        return false;
    }

    @Override
    public boolean isMessageDispatchNotification() {
        return false;
    }

    @Override
    public boolean isResponse() {
        return false;
    }

    @Override
    public boolean isResponseRequired() {
        return false;
    }

    @Override
    public boolean isShutdownInfo() {
        return false;
    }

    @Override
    public boolean isConnectionControl() {
        return false;
    }

    @Override
    public boolean isWireFormatInfo() {
        return false;
    }

    @Override
    public void setCommandId(int value) {
    }

    @Override
    public void setFrom(Endpoint from) {
    }

    @Override
    public void setResponseRequired(boolean responseRequired) {
    }

    @Override
    public void setTo(Endpoint to) {
    }

    @Override
    public Response visit(CommandVisitor visitor) throws Exception {
        return null;
    }

    @Override
    public byte getDataStructureType() {
        return 0;
    }

    @Override
    public boolean isMarshallAware() {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getAction());
        buffer.append("\n");
        Map<String, String> headers = this.getHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            buffer.append((Object)entry.getKey());
            buffer.append(":");
            buffer.append((Object)entry.getValue());
            buffer.append("\n");
        }
        buffer.append("\n");
        if (this.getContent() != null) {
            try {
                buffer.append(new String(this.getContent(), "UTF-8"));
            }
            catch (Throwable e) {
                buffer.append(Arrays.toString(this.getContent()));
            }
        }
        return buffer.toString();
    }
}

