/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.activemq.MessageAvailableConsumer;
import org.apache.activemq.web.AjaxListener;
import org.apache.activemq.web.WebClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxWebClient
extends WebClient {
    private static final Log LOG = LogFactory.getLog(AjaxWebClient.class);
    final long expireAfter = 60000L;
    Map<MessageAvailableConsumer, String> idMap = new HashMap<MessageAvailableConsumer, String>();
    Map<MessageAvailableConsumer, String> destinationNameMap = new HashMap<MessageAvailableConsumer, String>();
    AjaxListener listener;
    Long lastAccessed;

    public AjaxWebClient(HttpServletRequest request, long maximumReadTimeout) {
        this.listener = new AjaxListener(this, maximumReadTimeout);
        this.lastAccessed = this.getNow();
    }

    public Map<MessageAvailableConsumer, String> getIdMap() {
        return this.idMap;
    }

    public Map<MessageAvailableConsumer, String> getDestinationNameMap() {
        return this.destinationNameMap;
    }

    public AjaxListener getListener() {
        return this.listener;
    }

    public long getMillisSinceLastAccessed() {
        return this.getNow() - this.lastAccessed;
    }

    public void updateLastAccessed() {
        this.lastAccessed = this.getNow();
    }

    public boolean closeIfExpired() {
        long now = new Date().getTime();
        boolean returnVal = false;
        if (this.getMillisSinceLastAccessed() > this.expireAfter) {
            this.close();
            returnVal = true;
        }
        return returnVal;
    }

    protected long getNow() {
        return new Date().getTime();
    }
}

