/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.apache.activeio.packet.ByteSequence;
import org.apache.activeio.packet.EmptyPacket;
import org.apache.activeio.packet.Packet;

public final class BytePacket
implements Packet {
    private byte data;
    private byte position;
    private byte limit;

    public BytePacket(byte data) {
        this.data = data;
        this.clear();
    }

    public int position() {
        return this.position;
    }

    public void position(int position) {
        this.position = (byte)position;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = (byte)limit;
    }

    public void flip() {
        this.limit(this.position());
        this.position(0);
    }

    public int remaining() {
        return this.limit() - this.position();
    }

    public void rewind() {
        this.position(0);
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public void clear() {
        this.position(0);
        this.limit(this.capacity());
    }

    public int capacity() {
        return 1;
    }

    public Packet slice() {
        if (this.hasRemaining()) {
            return new BytePacket(this.data);
        }
        return EmptyPacket.EMPTY_PACKET;
    }

    public Packet duplicate() {
        BytePacket packet = new BytePacket(this.data);
        packet.limit(this.limit());
        packet.position(this.position());
        return packet;
    }

    public Object duplicate(ClassLoader cl) throws IOException {
        try {
            Class<?> clazz = cl.loadClass(BytePacket.class.getName());
            Constructor<?> constructor = clazz.getConstructor(Byte.TYPE);
            return constructor.newInstance(new Byte(this.data));
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Could not duplicate packet in a different classloader: " + e).initCause(e);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.hasRemaining()) {
            out.write(this.data);
            this.position(1);
        }
    }

    public void writeTo(DataOutput out) throws IOException {
        if (this.hasRemaining()) {
            out.write(this.data);
            this.position(1);
        }
    }

    public int read() {
        if (!this.hasRemaining()) {
            return -1;
        }
        this.position(1);
        return this.data & 0xFF;
    }

    public int read(byte[] data, int offset, int length) {
        if (!this.hasRemaining()) {
            return -1;
        }
        if (length > 0) {
            data[offset] = this.data;
            this.position(1);
            return 1;
        }
        return 0;
    }

    public boolean write(int data) {
        if (!this.hasRemaining()) {
            return false;
        }
        this.data = (byte)data;
        this.position(1);
        return true;
    }

    public int write(byte[] data, int offset, int length) {
        if (!this.hasRemaining()) {
            return -1;
        }
        if (length > 0) {
            this.data = data[offset];
            this.position(1);
            return 1;
        }
        return 0;
    }

    public ByteSequence asByteSequence() {
        return null;
    }

    public byte[] sliceAsBytes() {
        return null;
    }

    public int read(Packet dest) {
        if (this.hasRemaining()) {
            dest.write(this.data);
            this.position(1);
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "{position=" + this.position() + ",limit=" + this.limit() + ",capacity=" + this.capacity() + "}";
    }

    public Object getAdapter(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void dispose() {
    }
}

