/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.sequenceChooser.FileChooser;

public class ListFilePanel
extends JPanel {
    private int nFiles;
    private FileChooser[] fileChooser;

    public ListFilePanel(int n, JembossParams jembossParams) {
        super(new BorderLayout());
        this.nFiles = n;
        Box box = Box.createVerticalBox();
        this.fileChooser = new FileChooser[n];
        Dimension dimension = null;
        box.add(Box.createVerticalStrut(2));
        for (int i = 0; i < n; ++i) {
            this.fileChooser[i] = new FileChooser(box, "", jembossParams);
            if (dimension == null) {
                dimension = this.fileChooser[i].getPreferredSize();
                dimension = new Dimension(210, (int)dimension.getHeight());
            }
            this.fileChooser[i].setPreferredSize(dimension);
            box.add(Box.createVerticalStrut(2));
        }
        ScrollPanel scrollPanel = new ScrollPanel(new BorderLayout());
        scrollPanel.add(box);
        JScrollPane jScrollPane = new JScrollPane(scrollPanel);
        jScrollPane.setPreferredSize(new Dimension(350, 100));
        this.add((Component)jScrollPane, "West");
        this.setPreferredSize(new Dimension(350, 100));
        this.setMaximumSize(new Dimension(350, 100));
    }

    public String getListFile() {
        String string = "";
        String string2 = System.getProperty("line.separator");
        for (int i = 0; i < this.nFiles; ++i) {
            if (this.fileChooser[i].getFileChosen().equals("")) continue;
            string = string.concat(this.fileChooser[i].getFileChosen() + string2);
        }
        return string;
    }

    public String[] getArrayListFile() {
        int n = 0;
        for (int i = 0; i < this.nFiles; ++i) {
            if (this.fileChooser[i].getFileChosen().equals("")) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < this.nFiles; ++i) {
            if (this.fileChooser[i].getFileChosen().equals("")) continue;
            stringArray[i] = this.fileChooser[i].getFileChosen();
        }
        return stringArray;
    }

    public boolean writeListFile(String string) {
        boolean bl = true;
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.getListFile());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public String getSequence(int n) {
        String string = "";
        int n2 = 0;
        for (int i = 0; i < this.nFiles; ++i) {
            if (this.fileChooser[i].getFileChosen().equals("") || ++n2 != n) continue;
            string = this.fileChooser[i].getFileChosen();
            break;
        }
        return string;
    }

    public void doReset() {
        for (int i = 0; i < this.nFiles; ++i) {
            this.fileChooser[i].setText("");
        }
    }
}

