/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequenceFileWalker;
import net.sf.picard.sam.MultiHitAlignedReadIterator;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.picard.sam.ReservedTagConstants;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.CigarUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMRecordUtil;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTag;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.SortingCollection;

public abstract class AbstractAlignmentMerger {
    public static final int MAX_RECORDS_IN_RAM = 500000;
    private static final char[] RESERVED_ATTRIBUTE_STARTS = new char[]{'X', 'Y', 'Z'};
    private final NumberFormat FMT = new DecimalFormat("#,###");
    private final Log log = Log.getInstance(AbstractAlignmentMerger.class);
    private final File unmappedBamFile;
    private final File targetBamFile;
    private final SAMSequenceDictionary sequenceDictionary;
    private ReferenceSequenceFileWalker refSeq = null;
    private final boolean clipAdapters;
    private final boolean bisulfiteSequence;
    private SAMProgramRecord programRecord;
    private final boolean alignedReadsOnly;
    private final SAMFileHeader header;
    private final List<String> attributesToRetain = new ArrayList<String>();
    private final File referenceFasta;
    private final Integer read1BasesTrimmed;
    private final Integer read2BasesTrimmed;
    private final List<SamPairUtil.PairOrientation> expectedOrientations;
    private final SAMFileHeader.SortOrder sortOrder;
    private MultiHitAlignedReadIterator alignedIterator = null;
    private boolean clipOverlappingReads = true;
    private int maxRecordsInRam = 500000;
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private final SamRecordFilter alignmentFilter = new SamRecordFilter(){

        @Override
        public boolean filterOut(SAMRecord record) {
            return AbstractAlignmentMerger.this.ignoreAlignment(record);
        }

        @Override
        public boolean filterOut(SAMRecord first, SAMRecord second) {
            throw new UnsupportedOperationException("Paired SamRecordFilter not implemented!");
        }
    };

    protected abstract CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords();

    protected boolean ignoreAlignment(SAMRecord sam) {
        return false;
    }

    public AbstractAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, boolean clipAdapters, boolean bisulfiteSequence, boolean alignedReadsOnly, SAMProgramRecord programRecord, List<String> attributesToRetain, Integer read1BasesTrimmed, Integer read2BasesTrimmed, List<SamPairUtil.PairOrientation> expectedOrientations, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        IoUtil.assertFileIsReadable(unmappedBamFile);
        IoUtil.assertFileIsWritable(targetBamFile);
        IoUtil.assertFileIsReadable(referenceFasta);
        this.unmappedBamFile = unmappedBamFile;
        this.targetBamFile = targetBamFile;
        this.referenceFasta = referenceFasta;
        this.refSeq = new ReferenceSequenceFileWalker(referenceFasta);
        this.sequenceDictionary = this.refSeq.getSequenceDictionary();
        if (this.sequenceDictionary == null) {
            throw new PicardException("No sequence dictionary found for " + referenceFasta.getAbsolutePath() + ".  Use CreateSequenceDictionary.jar to create a sequence dictionary.");
        }
        this.clipAdapters = clipAdapters;
        this.bisulfiteSequence = bisulfiteSequence;
        this.alignedReadsOnly = alignedReadsOnly;
        this.header = new SAMFileHeader();
        this.sortOrder = sortOrder != null ? sortOrder : SAMFileHeader.SortOrder.coordinate;
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        if (programRecord != null) {
            this.setProgramRecord(programRecord);
        }
        this.header.setSequenceDictionary(this.sequenceDictionary);
        if (attributesToRetain != null) {
            this.attributesToRetain.addAll(attributesToRetain);
        }
        this.read1BasesTrimmed = read1BasesTrimmed;
        this.read2BasesTrimmed = read2BasesTrimmed;
        this.expectedOrientations = expectedOrientations;
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
    }

    public void setMaxRecordsInRam(int maxRecordsInRam) {
        this.maxRecordsInRam = maxRecordsInRam;
    }

    public void mergeAlignment() {
        SAMFileReader unmappedSam = new SAMFileReader(this.unmappedBamFile);
        SAMRecordIterator unmappedIterator = unmappedSam.iterator();
        this.header.setReadGroups(unmappedSam.getFileHeader().getReadGroups());
        int aligned = 0;
        int unmapped = 0;
        this.alignedIterator = new MultiHitAlignedReadIterator(this.getQuerynameSortedAlignedRecords(), this.primaryAlignmentSelectionStrategy);
        MultiHitAlignedReadIterator.HitsForInsert nextAligned = this.nextAligned();
        SortingCollection sorted = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(this.header), (Comparator)new SAMRecordCoordinateComparator(), (int)500000);
        while (unmappedIterator.hasNext()) {
            SAMRecord secondOfPair;
            SAMRecord rec = (SAMRecord)unmappedIterator.next();
            rec.setHeader(this.header);
            if (rec.getReadPairedFlag()) {
                secondOfPair = (SAMRecord)unmappedIterator.next();
                secondOfPair.setHeader(this.header);
                if (!rec.getReadName().equals(secondOfPair.getReadName())) {
                    throw new PicardException("Second read from pair not found in unmapped bam: " + rec.getReadName() + ", " + secondOfPair.getReadName());
                }
                if (!rec.getFirstOfPairFlag()) {
                    throw new PicardException("First record in unmapped bam is not first of pair: " + rec.getReadName());
                }
                if (!secondOfPair.getReadPairedFlag()) {
                    throw new PicardException("Second record in unmapped bam is not marked as paired: " + secondOfPair.getReadName());
                }
                if (!secondOfPair.getSecondOfPairFlag()) {
                    throw new PicardException("Second record in unmapped bam is not second of pair: " + secondOfPair.getReadName());
                }
            } else {
                secondOfPair = null;
            }
            if (nextAligned != null && rec.getReadName().equals(nextAligned.getReadName())) {
                int i;
                boolean clone;
                boolean bl = clone = nextAligned.numHits() > 1;
                if (rec.getReadPairedFlag()) {
                    for (i = 0; i < nextAligned.numHits(); ++i) {
                        SAMRecord secondToWrite;
                        SAMRecord firstToWrite;
                        if (clone) {
                            firstToWrite = this.clone(rec);
                            secondToWrite = this.clone(secondOfPair);
                        } else {
                            firstToWrite = rec;
                            secondToWrite = secondOfPair;
                        }
                        SAMRecord firstAligned = nextAligned.getFirstOfPair(i);
                        SAMRecord secondAligned = nextAligned.getSecondOfPair(i);
                        boolean isPrimaryAlignment = firstAligned != null && !firstAligned.getNotPrimaryAlignmentFlag() || secondAligned != null && !secondAligned.getNotPrimaryAlignmentFlag();
                        this.transferAlignmentInfoToPairedRead(firstToWrite, secondToWrite, firstAligned, secondAligned);
                        if (!firstToWrite.getReadUnmappedFlag() || isPrimaryAlignment) {
                            sorted.add((Object)firstToWrite);
                            if (firstToWrite.getReadUnmappedFlag()) {
                                ++unmapped;
                            } else {
                                ++aligned;
                            }
                        }
                        if (secondToWrite.getReadUnmappedFlag() && !isPrimaryAlignment) continue;
                        sorted.add((Object)secondToWrite);
                        if (!secondToWrite.getReadUnmappedFlag()) {
                            ++aligned;
                            continue;
                        }
                        ++unmapped;
                    }
                } else {
                    for (i = 0; i < nextAligned.numHits(); ++i) {
                        SAMRecord recToWrite = clone ? this.clone(rec) : rec;
                        this.transferAlignmentInfoToFragment(recToWrite, nextAligned.getFragment(i));
                        sorted.add((Object)recToWrite);
                        if (recToWrite.getReadUnmappedFlag()) {
                            ++unmapped;
                            continue;
                        }
                        ++aligned;
                    }
                }
                nextAligned = this.nextAligned();
            } else {
                if (nextAligned != null && SAMRecordQueryNameComparator.compareReadNames((String)rec.getReadName(), (String)nextAligned.getReadName()) > 0) {
                    throw new IllegalStateException("Aligned record iterator (" + nextAligned.getReadName() + ") is behind the unmapped reads (" + rec.getReadName() + ")");
                }
                if (!this.alignedReadsOnly) {
                    sorted.add((Object)rec);
                    ++unmapped;
                    if (secondOfPair != null) {
                        sorted.add((Object)secondOfPair);
                        ++unmapped;
                    }
                }
            }
            if ((aligned + unmapped) % 1000000 != 0) continue;
            this.log.info("Processed " + this.FMT.format(aligned + unmapped) + " records in query name order.");
        }
        unmappedIterator.close();
        if (this.alignedIterator.hasNext()) {
            throw new IllegalStateException("Reads remaining on alignment iterator: " + this.alignedIterator.next().getReadName() + "!");
        }
        this.alignedIterator.close();
        this.header.setSortOrder(this.sortOrder);
        boolean presorted = this.sortOrder == SAMFileHeader.SortOrder.coordinate;
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(this.header, presorted, this.targetBamFile);
        int count = 0;
        for (SAMRecord rec : sorted) {
            if (!rec.getReadUnmappedFlag() && this.refSeq != null) {
                byte[] referenceBases = this.refSeq.get(this.sequenceDictionary.getSequenceIndex(rec.getReferenceName())).getBases();
                rec.setAttribute(SAMTag.NM.name(), (Object)SequenceUtil.calculateSamNmTag((SAMRecord)rec, (byte[])referenceBases, (int)0, (boolean)this.bisulfiteSequence));
                if (rec.getBaseQualities() != SAMRecord.NULL_QUALS) {
                    rec.setAttribute(SAMTag.UQ.name(), (Object)SequenceUtil.sumQualitiesOfMismatches((SAMRecord)rec, (byte[])referenceBases, (int)0, (boolean)this.bisulfiteSequence));
                }
            }
            writer.addAlignment(rec);
            if (++count % 1000000 != 0) continue;
            this.log.info(this.FMT.format(count) + " SAMRecords written to " + this.targetBamFile.getName());
        }
        writer.close();
        sorted.cleanup();
        this.log.info("Wrote " + aligned + " alignment records and " + (this.alignedReadsOnly ? 0 : unmapped) + " unmapped reads.");
    }

    private SAMRecord clone(SAMRecord rec) {
        try {
            return (SAMRecord)rec.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new PicardException("Should never happen.");
        }
    }

    private MultiHitAlignedReadIterator.HitsForInsert nextAligned() {
        while (this.alignedIterator.hasNext()) {
            MultiHitAlignedReadIterator.HitsForInsert hits = this.alignedIterator.next();
            hits.filterReads(this.alignmentFilter, this.primaryAlignmentSelectionStrategy);
            if (hits.numHits() <= 0) continue;
            return hits;
        }
        return null;
    }

    private void transferAlignmentInfoToFragment(SAMRecord unaligned, SAMRecord aligned) {
        this.setValuesFromAlignment(unaligned, aligned);
        this.updateCigarForTrimmedOrClippedBases(unaligned, aligned);
        if (this.programRecord != null) {
            unaligned.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)this.programRecord.getProgramGroupId());
        }
        if (SAMUtils.cigarMapsNoBasesToRef((Cigar)unaligned.getCigar())) {
            SAMUtils.makeReadUnmapped((SAMRecord)unaligned);
        }
    }

    private void transferAlignmentInfoToPairedRead(SAMRecord firstUnaligned, SAMRecord secondUnaligned, SAMRecord firstAligned, SAMRecord secondAligned) {
        if (firstAligned != null) {
            this.transferAlignmentInfoToFragment(firstUnaligned, firstAligned);
        }
        if (secondAligned != null) {
            this.transferAlignmentInfoToFragment(secondUnaligned, secondAligned);
        }
        if (this.isClipOverlappingReads()) {
            this.clipForOverlappingReads(firstUnaligned, secondUnaligned);
        }
        SamPairUtil.setProperPairAndMateInfo(secondUnaligned, firstUnaligned, this.header, this.expectedOrientations);
    }

    protected void clipForOverlappingReads(SAMRecord read1, SAMRecord read2) {
        if (!read1.getReadUnmappedFlag() && !read2.getReadUnmappedFlag() && read1.getReadNegativeStrandFlag() != read2.getReadNegativeStrandFlag()) {
            SAMRecord neg;
            SAMRecord pos = read1.getReadNegativeStrandFlag() ? read2 : read1;
            SAMRecord sAMRecord = neg = read1.getReadNegativeStrandFlag() ? read1 : read2;
            if (pos.getAlignmentStart() < neg.getAlignmentEnd()) {
                int posDiff = pos.getAlignmentEnd() - neg.getAlignmentEnd();
                int negDiff = pos.getAlignmentStart() - neg.getAlignmentStart();
                if (posDiff > 0) {
                    CigarUtil.softClip3PrimeEndOfRead(pos, Math.min(pos.getReadLength(), pos.getReadLength() - posDiff + 1));
                }
                if (negDiff > 0) {
                    CigarUtil.softClip3PrimeEndOfRead(neg, Math.min(neg.getReadLength(), neg.getReadLength() - negDiff + 1));
                }
            }
        }
    }

    protected void setValuesFromAlignment(SAMRecord rec, SAMRecord alignment) {
        for (SAMRecord.SAMTagAndValue attr : alignment.getAttributes()) {
            if (this.isReservedTag(attr.tag) && !this.attributesToRetain.contains(attr.tag)) continue;
            rec.setAttribute(attr.tag, attr.value);
        }
        rec.setReadUnmappedFlag(alignment.getReadUnmappedFlag());
        rec.setReferenceName(alignment.getReferenceName());
        rec.setAlignmentStart(alignment.getAlignmentStart());
        rec.setReadNegativeStrandFlag(alignment.getReadNegativeStrandFlag());
        rec.setNotPrimaryAlignmentFlag(alignment.getNotPrimaryAlignmentFlag());
        if (!alignment.getReadUnmappedFlag()) {
            rec.setCigar(alignment.getCigar());
            rec.setMappingQuality(alignment.getMappingQuality());
        }
        if (rec.getReadPairedFlag()) {
            rec.setProperPairFlag(alignment.getProperPairFlag());
        }
        if (rec.getReadNegativeStrandFlag()) {
            SAMRecordUtil.reverseComplement((SAMRecord)rec);
        }
    }

    protected void updateCigarForTrimmedOrClippedBases(SAMRecord rec, SAMRecord alignment) {
        SAMSequenceRecord refseq = rec.getHeader().getSequence(rec.getReferenceIndex().intValue());
        if (rec.getAlignmentEnd() > refseq.getSequenceLength()) {
            int clipFrom = refseq.getSequenceLength() - rec.getAlignmentStart() + 1;
            List<CigarElement> newCigarElements = CigarUtil.softClipEndOfRead(clipFrom, rec.getCigar().getCigarElements());
            rec.setCigar(new Cigar(newCigarElements));
        }
        int alignmentReadLength = alignment.getReadLength();
        int originalReadLength = rec.getReadLength();
        int trimmed = !rec.getReadPairedFlag() || rec.getFirstOfPairFlag() ? (this.read1BasesTrimmed != null ? this.read1BasesTrimmed : 0) : (this.read2BasesTrimmed != null ? this.read2BasesTrimmed : 0);
        int notWritten = originalReadLength - (alignmentReadLength + trimmed);
        rec.setCigar(CigarUtil.addSoftClippedBasesToEndsOfCigar(rec.getCigar(), rec.getReadNegativeStrandFlag(), notWritten, trimmed));
        if (this.clipAdapters && rec.getAttribute("XT") != null) {
            CigarUtil.softClip3PrimeEndOfRead(rec, rec.getIntegerAttribute("XT"));
        }
    }

    protected SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    protected SAMProgramRecord getProgramRecord() {
        return this.programRecord;
    }

    protected void setProgramRecord(SAMProgramRecord pg) {
        if (this.programRecord != null) {
            throw new IllegalStateException("Cannot set program record more than once on alignment merger.");
        }
        this.programRecord = pg;
        this.header.addProgramRecord(pg);
        SAMUtils.chainSAMProgramRecord((SAMFileHeader)this.header, (SAMProgramRecord)pg);
    }

    protected boolean isReservedTag(String tag) {
        char firstCharOfTag = tag.charAt(0);
        if (Character.isLowerCase(firstCharOfTag)) {
            return true;
        }
        for (char c : RESERVED_ATTRIBUTE_STARTS) {
            if (firstCharOfTag != c) continue;
            return true;
        }
        return false;
    }

    protected SAMFileHeader getHeader() {
        return this.header;
    }

    protected void resetRefSeqFileWalker() {
        this.refSeq = new ReferenceSequenceFileWalker(this.referenceFasta);
    }

    public boolean isClipOverlappingReads() {
        return this.clipOverlappingReads;
    }

    public void setClipOverlappingReads(boolean clipOverlappingReads) {
        this.clipOverlappingReads = clipOverlappingReads;
    }
}

