/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import java.io.File;
import java.util.List;
import java.util.Set;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.directed.CollectTargetedMetrics;
import net.sf.picard.analysis.directed.HsMetricCollector;
import net.sf.picard.analysis.directed.TargetMetricsCollector;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.samtools.SAMReadGroupRecord;

public class CalculateHsMetrics
extends CollectTargetedMetrics {
    @Usage
    public final String USAGE = "Calculates a set of Hybrid Selection specific metrics from an aligned SAMor BAM file. If a reference sequence is provided, AT/GC dropout metrics will be calculated, and the PER_TARGET_COVERAGE option can be used to output GC and mean coverage information for every target.";
    @Option(shortName="BI", doc="An interval list file that contains the locations of the baits used.")
    public File BAIT_INTERVALS;
    @Option(shortName="N", doc="Bait set name. If not provided it is inferred from the filename of the bait intervals.", optional=true)
    public String BAIT_SET_NAME;

    @Override
    protected File getProbeIntervals() {
        return this.BAIT_INTERVALS;
    }

    @Override
    protected String getProbeSetName() {
        return this.BAIT_SET_NAME;
    }

    public static void main(String[] argv) {
        System.exit(new CalculateHsMetrics().instanceMain(argv));
    }

    @Override
    protected TargetMetricsCollector makeCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, File targetIntervals, File probeIntervals, String probeSetName) {
        return new HsMetricCollector(accumulationLevels, samRgRecords, refFile, perTargetCoverage, targetIntervals, probeIntervals, probeSetName);
    }
}

