/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.security;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Map;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.security.Authentication;
import org.eclipse.jetty.client.security.Realm;
import org.eclipse.jetty.util.TypeUtil;

public class DigestAuthentication
implements Authentication {
    private static final String NC = "00000001";
    Realm securityRealm;
    Map details;

    public DigestAuthentication(Realm realm, Map details) {
        this.securityRealm = realm;
        this.details = details;
    }

    @Override
    public void setCredentials(HttpExchange exchange) throws IOException {
        StringBuilder buffer = new StringBuilder().append("Digest");
        buffer.append(" ").append("username").append('=').append('\"').append(this.securityRealm.getPrincipal()).append('\"');
        buffer.append(", ").append("realm").append('=').append('\"').append(String.valueOf(this.details.get("realm"))).append('\"');
        buffer.append(", ").append("nonce").append('=').append('\"').append(String.valueOf(this.details.get("nonce"))).append('\"');
        buffer.append(", ").append("uri").append('=').append('\"').append(exchange.getURI()).append('\"');
        buffer.append(", ").append("algorithm").append('=').append(String.valueOf(this.details.get("algorithm")));
        String cnonce = this.newCnonce(exchange, this.securityRealm, this.details);
        buffer.append(", ").append("response").append('=').append('\"').append(this.newResponse(cnonce, exchange, this.securityRealm, this.details)).append('\"');
        buffer.append(", ").append("qop").append('=').append(String.valueOf(this.details.get("qop")));
        buffer.append(", ").append("nc").append('=').append(NC);
        buffer.append(", ").append("cnonce").append('=').append('\"').append(cnonce).append('\"');
        exchange.setRequestHeader("Authorization", new String(buffer.toString().getBytes("ISO-8859-1")));
    }

    protected String newResponse(String cnonce, HttpExchange exchange, Realm securityRealm, Map details) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(securityRealm.getPrincipal().getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(String.valueOf(details.get("realm")).getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(securityRealm.getCredentials().getBytes("ISO-8859-1"));
            byte[] ha1 = md.digest();
            md.reset();
            md.update(exchange.getMethod().getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(exchange.getURI().getBytes("ISO-8859-1"));
            byte[] ha2 = md.digest();
            md.update(TypeUtil.toString((byte[])ha1, (int)16).getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(String.valueOf(details.get("nonce")).getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(NC.getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(cnonce.getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(String.valueOf(details.get("qop")).getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(TypeUtil.toString((byte[])ha2, (int)16).getBytes("ISO-8859-1"));
            byte[] digest = md.digest();
            return DigestAuthentication.encode(digest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String newCnonce(HttpExchange exchange, Realm securityRealm, Map details) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] b = md.digest(String.valueOf(System.currentTimeMillis()).getBytes("ISO-8859-1"));
            return DigestAuthentication.encode(b);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String encode(byte[] data) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            buffer.append(Integer.toHexString((data[i] & 0xF0) >>> 4));
            buffer.append(Integer.toHexString(data[i] & 0xF));
        }
        return buffer.toString();
    }
}

