/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.view;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.jms.TextMessage;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.web.view.SimpleMessageRenderer;

public class RssMessageRenderer
extends SimpleMessageRenderer {
    private String feedType = "rss_2.0";
    private SyndFeed feed;
    private String description = "This feed is auto-generated by Apache ActiveMQ";
    private String entryContentType = "text/plain";

    public void renderMessage(PrintWriter writer, HttpServletRequest request, HttpServletResponse response, QueueBrowser browser, Message message) throws JMSException {
        SyndFeed feed = this.getFeed(browser, request);
        List entries = feed.getEntries();
        SyndEntry entry = this.createEntry(browser, message, request);
        SyndContent description = this.createEntryContent(browser, message, request);
        entry.setDescription(description);
        entries.add(entry);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String feedDescription) {
        this.description = feedDescription;
    }

    public String getFeedType() {
        return this.feedType;
    }

    public void setFeedType(String feedType) {
        this.feedType = feedType;
    }

    public String getEntryContentType() {
        return this.entryContentType;
    }

    public void setEntryContentType(String entryContentType) {
        this.entryContentType = entryContentType;
    }

    protected void printFooter(PrintWriter writer, QueueBrowser browser, HttpServletRequest request) throws IOException, JMSException, ServletException {
        SyndFeed feed = this.getFeed(browser, request);
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            output.output(feed, (Writer)writer);
        }
        catch (FeedException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void printHeader(PrintWriter writer, QueueBrowser browser, HttpServletRequest request) throws IOException, JMSException {
    }

    public SyndFeed getFeed(QueueBrowser browser, HttpServletRequest request) throws JMSException {
        if (this.feed == null) {
            this.feed = this.createFeed(browser, request);
        }
        return this.feed;
    }

    protected SyndEntry createEntry(QueueBrowser browser, Message message, HttpServletRequest request) throws JMSException {
        SyndEntryImpl entry = new SyndEntryImpl();
        String title = message.getJMSMessageID();
        entry.setTitle(title);
        String link = request.getRequestURI() + "?msgId=" + title;
        entry.setLink(link);
        entry.setPublishedDate(new Date());
        return entry;
    }

    protected SyndContent createEntryContent(QueueBrowser browser, Message message, HttpServletRequest request) throws JMSException {
        SyndContentImpl description = new SyndContentImpl();
        description.setType(this.entryContentType);
        if (message instanceof TextMessage) {
            String text = ((TextMessage)message).getText();
            description.setValue(text);
        }
        return description;
    }

    protected SyndFeed createFeed(QueueBrowser browser, HttpServletRequest request) throws JMSException {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(this.feedType);
        String title = browser.getQueue().toString();
        String selector = browser.getMessageSelector();
        if (selector != null) {
            title = title + " with selector: " + selector;
        }
        feed.setTitle(title);
        feed.setLink(request.getRequestURI());
        feed.setDescription(this.getDescription());
        return feed;
    }
}

