/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

public class ByteRegion
implements Comparable<ByteRegion> {
    public Long start;
    public Long end;
    public boolean exact;

    public ByteRegion(Long start, Long end, boolean exact) {
        this.start = start;
        this.end = end;
        this.exact = exact;
    }

    public ByteRegion() {
        this(null, null, false);
    }

    public long getLength() {
        return this.end - this.start;
    }

    public double getMid() {
        return (double)(this.start + this.end) / 2.0;
    }

    public String toString() {
        return "RowRegion [" + this.start + " - " + this.end + "]";
    }

    public ByteRegion clone() {
        return new ByteRegion(this.start, this.end, this.exact);
    }

    public boolean intercepts(ByteRegion other) {
        return this.end >= other.start && this.start < other.end;
    }

    public ByteRegion intercept(ByteRegion other) {
        return new ByteRegion(Math.max(this.start, other.start), Math.min(this.end, other.end), this.exact);
    }

    @Override
    public int compareTo(ByteRegion o) {
        int startComparison = this.start.compareTo(this.start);
        if (startComparison != 0) {
            return startComparison;
        }
        return this.end.compareTo(o.end);
    }

    public boolean equals(Object o) {
        if (o instanceof ByteRegion) {
            ByteRegion other = (ByteRegion)o;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode();
    }

    public boolean contains(Long point) {
        return point >= this.start && point < this.end;
    }
}

