/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Type;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class SNPParser
extends TsvParser {
    public SNPParser() {
        super(new FileDefinition((Collection<ColumnDefinition>)Arrays.asList(new ColumnDefinition(ColumnType.ID, Type.STRING), new ColumnDefinition(ColumnType.CHROMOSOME, Type.LONG), new ColumnDefinition(ColumnType.POSITION, Type.LONG), new ColumnDefinition(ColumnType.ALLELE, Type.STRING), new ColumnDefinition(ColumnType.STRAND, Type.STRING), new ColumnDefinition(ColumnType.CONSEQUENCE_TO_TRANSCRIPT, Type.STRING))));
    }

    @Override
    public RegionContent[] concise(Chunk chunk) {
        return null;
    }

    @Override
    public String getName() {
        return "SNP Parser";
    }

    @Override
    public Region getBpRegion(Chunk chunk) {
        String[] firstRow = this.getFirstRow(chunk);
        String[] lastRow = this.getLastRow(chunk);
        Long start = (Long)this.get(firstRow, ColumnType.POSITION);
        Long end = (Long)this.get(lastRow, ColumnType.POSITION);
        Chromosome startChr = (Chromosome)this.get(firstRow, ColumnType.CHROMOSOME);
        Chromosome endChr = (Chromosome)this.get(lastRow, ColumnType.CHROMOSOME);
        return new Region(start, startChr, end, endChr);
    }

    @Override
    public List<RegionContent> getAll(Chunk chunk, Collection<ColumnType> requestedContents) {
        LinkedList<RegionContent> rows = new LinkedList<RegionContent>();
        for (String row : chunk.getContent().split("\n")) {
            LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
            String[] cols = row.split("\t");
            for (ColumnType requestedContent : requestedContents) {
                values.put(requestedContent, this.get(cols, requestedContent));
            }
            Long start = (Long)this.get(cols, ColumnType.POSITION);
            Long end = (Long)this.get(cols, ColumnType.POSITION);
            Chromosome chr = (Chromosome)this.get(cols, ColumnType.CHROMOSOME);
            rows.add(new RegionContent(new Region(start, end, chr), values));
        }
        return rows;
    }

    @Override
    public Object get(String[] cols, ColumnType col) {
        try {
            if (cols.length <= 1) {
                return null;
            }
            String string = cols[this.getFileDefinition().indexOf(col)].trim();
            ColumnDefinition fieldDef = this.getFileDefinition().getFieldDef(col);
            if (col == ColumnType.STRAND) {
                return string.equals("-1") || string.equalsIgnoreCase("r") || string.equals("-") ? Strand.REVERSED : Strand.FORWARD;
            }
            if (col == ColumnType.CHROMOSOME) {
                return new Chromosome(string);
            }
            if (col == ColumnType.CONSEQUENCE_TO_TRANSCRIPT) {
                if (string.startsWith("3PRIME")) {
                    return "PRIME3_UTR";
                }
                if (string.startsWith("5PRIME")) {
                    return "PRIME5_UTR";
                }
                if (string.startsWith("STOP_GAINED,FRAMESHIFT")) {
                    return "STOP_GAINED_FRAMESHIFT_CODING";
                }
                if (string.startsWith("STOP_GAINED,SPLICE_SITE")) {
                    return "STOP_GAINED_SPLICED_SITE";
                }
                if (string.startsWith("STOP_LOST,SPLICE_SITE")) {
                    return "STOP_LOST_SPLICE_SITE";
                }
                if (string.startsWith("FRAMESHIFT_CODING,SPLICE_SITE")) {
                    return "FRAMESHIFT_CODING_SPLICE_SITE";
                }
                if (string.startsWith("STOP_GAINED,FRAMESHIFT_CODING,SPLICE_SITE")) {
                    return "STOP_GAINED_FRAMESHIFT_CODING_SPLICE_SITE";
                }
                if (string.startsWith("NON_SYNONYMOUS_CODING,SPLICE_SITE")) {
                    return "NON_SYNONYMOUS_CODING_SPLICE_SITE";
                }
                if (string.startsWith("SPLICE_SITE,SYNONYMOUS_CODING")) {
                    return "SPLICE_SITE_SYNONYMOUS_CODING";
                }
                if (string.startsWith("SPLICE_SITE,5PRIME_UTR")) {
                    return "SPLICE_SITE_5PRIME_UTR";
                }
                if (string.startsWith("SPLICE_SITE,3PRIME_UTR")) {
                    return "SPLICE_SITE_3PRIME_UTR";
                }
                if (string.startsWith("ESSENTIAL_SPLICE_SITE,INTRONIC")) {
                    return "ESSENTIAL_SPLICE_SITE_INTRONIC";
                }
                if (string.startsWith("SPLICE_SITE,INTRONIC")) {
                    return "SPLICE_SITE_INTRONIC";
                }
                if (string.startsWith("INTRONIC,NMD_TRANSCRIPT")) {
                    return "INTRONIC_NMD_TRANSCRIPT";
                }
                return string;
            }
            if (fieldDef.type == Type.STRING) {
                return string;
            }
            if (fieldDef.type == Type.FLOAT) {
                return new Float(string);
            }
            if (fieldDef.type == Type.LONG) {
                if (string.length() > 0) {
                    return new Long(string);
                }
                return Long.MIN_VALUE;
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            if (col == ColumnType.CONSEQUENCE_TO_TRANSCRIPT) {
                return "NONE";
            }
            throw new RuntimeException("error parsing columns: " + Arrays.toString(cols) + " (looking for: " + (Object)((Object)col) + ")", e);
        }
        catch (Exception e) {
            throw new RuntimeException("error parsing columns: " + Arrays.toString(cols) + " (looking for: " + (Object)((Object)col) + ")", e);
        }
    }

    @Override
    public long getHeaderLength(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader reader = new BufferedReader(fileReader);
            try {
                return reader.readLine().length();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return 0L;
    }
}

