/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

public class Delimiter {
    public static final Delimiter TAB = new Delimiter("Tab", "\t");
    public static final Delimiter SPACE = new Delimiter("Space", " ");
    public static final Delimiter COMMA = new Delimiter("Comma", ",");
    public static final Delimiter SEMICOLON = new Delimiter("Semicolon", ";");
    private static final Delimiter[] delimiters = new Delimiter[]{TAB, SPACE, COMMA, SEMICOLON};
    private String name;
    private String string;

    private Delimiter(String name, String string) {
        this.name = name;
        this.string = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.string;
    }

    public void setDelimiterString(String string) {
        this.string = string;
    }

    public static Delimiter[] values() {
        return delimiters;
    }

    public static Delimiter stringToDelim(String delimString) {
        for (Delimiter delim : Delimiter.values()) {
            if (!delim.toString().equals(delimString)) continue;
            return delim;
        }
        return Delimiter.createCustomDelimiter(delimString);
    }

    private static Delimiter createCustomDelimiter(String delimiter) {
        return new Delimiter("Custom", delimiter);
    }

    public static boolean isCustom(String delimString) {
        for (Delimiter delim : Delimiter.values()) {
            if (!delim.toString().equals(delimString)) continue;
            return false;
        }
        return true;
    }
}

