/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.LinkUtil;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.util.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXHyperlink;

public class QuickLinkPanel
extends JPanel {
    private SwingClientApplication application = (SwingClientApplication)Session.getSession().getApplication();
    private JXHyperlink sessionLink;
    private JXHyperlink importLink;
    private JXHyperlink exampleLink;
    private JXHyperlink exampleLinkAlternative;
    private JXHyperlink importFolderLink;
    private JXHyperlink importURLLink;
    private static final int MAX_ROW_CHARS = 42;

    public QuickLinkPanel() {
        super(new GridBagLayout());
        this.setBackground(Color.white);
        this.exampleLink = null;
        this.exampleLinkAlternative = null;
        try {
            final URL[] urls = Session.getSession().getPrimaryModule().getExampleSessionUrls(this.application.isStandalone);
            if (urls != null) {
                if (urls.length == 1) {
                    this.exampleLink = LinkUtil.createLink("Example session ", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                QuickLinkPanel.this.application.loadSessionFrom(urls[0]);
                            }
                            catch (Exception exception) {
                                QuickLinkPanel.this.application.reportException(exception);
                            }
                        }
                    });
                }
                if (urls.length == 2) {
                    this.exampleLink = LinkUtil.createLink("microarray", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                QuickLinkPanel.this.application.loadSessionFrom(urls[0]);
                            }
                            catch (Exception exception) {
                                QuickLinkPanel.this.application.reportException(exception);
                            }
                        }
                    });
                    this.exampleLinkAlternative = LinkUtil.createLink("NGS", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                QuickLinkPanel.this.application.loadSessionFrom(urls[1]);
                            }
                            catch (Exception exception) {
                                QuickLinkPanel.this.application.reportException(exception);
                            }
                        }
                    });
                }
            }
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        this.importLink = LinkUtil.createLink("Import files ", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    QuickLinkPanel.this.application.openFileImport();
                }
                catch (Exception exception) {
                    QuickLinkPanel.this.application.reportException(exception);
                }
            }
        });
        this.importFolderLink = LinkUtil.createLink("Import folder ", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickLinkPanel.this.application.openDirectoryImportDialog();
            }
        });
        this.importURLLink = LinkUtil.createLink("Import from URL ", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    QuickLinkPanel.this.application.openURLImport();
                }
                catch (Exception exception) {
                    QuickLinkPanel.this.application.reportException(exception);
                }
            }
        });
        this.sessionLink = LinkUtil.createLink("Open session ", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuickLinkPanel.this.application.loadSession();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.insets.set(5, 10, 5, 10);
        c.gridwidth = 2;
        this.add((Component)new JLabel("To start working with " + Session.getSession().getPrimaryModule().getDisplayName() + ", you need to load in data first:"), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.insets.set(0, 10, 0, 0);
        if (this.exampleLink != null) {
            if (this.exampleLinkAlternative == null) {
                this.exampleLink.setText("Open example session ");
                QuickLinkPanel.addLink("*** to get familiar with " + Session.getSession().getPrimaryModule().getDisplayName() + ". ", this.exampleLink, VisualConstants.EXAMPLE_SESSION_ICON, c, this);
            } else {
                LinkedList<JXHyperlink> exampleLinks = new LinkedList<JXHyperlink>();
                exampleLinks.add(this.exampleLink);
                exampleLinks.add(this.exampleLinkAlternative);
                QuickLinkPanel.addLinks("Open example session (*** or ***) to get familiar with " + Session.getSession().getPrimaryModule().getDisplayName() + ". ", exampleLinks, VisualConstants.EXAMPLE_SESSION_ICON, c, this);
            }
        }
        QuickLinkPanel.addLink("*** to continue working on previous sessions.", this.sessionLink, VisualConstants.OPEN_SESSION_LINK_ICON, c, this);
        LinkedList<JXHyperlink> importLinks = new LinkedList<JXHyperlink>();
        importLinks.add(this.importLink);
        importLinks.add(this.importFolderLink);
        importLinks.add(this.importURLLink);
        if (!this.application.isStandalone) {
            Module primaryModule = Session.getSession().getPrimaryModule();
            primaryModule.addImportLinks(this, importLinks);
        }
        String linkTemplate = Strings.repeat("\n      *** ", importLinks.size());
        QuickLinkPanel.addLinks("Import new data to " + Session.getSession().getPrimaryModule().getDisplayName() + ": " + linkTemplate, importLinks, VisualConstants.IMPORT_LINK_ICON, c, this);
        JPanel bottomPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        bottomPanel.setBackground(Color.white);
        rightPanel.setBackground(Color.white);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)bottomPanel, c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 0;
        this.add((Component)rightPanel, c);
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(360, 250));
    }

    public static void addLink(String description, JXHyperlink link, ImageIcon icon, GridBagConstraints c, JComponent component) {
        LinkUtil.addLink(description, link, icon, c, component, 42, Color.white);
    }

    public static void addLinks(String description, List<JXHyperlink> links, ImageIcon icon, GridBagConstraints c, JComponent component) {
        LinkUtil.addLinks(description, links, icon, c, component, 42, Color.white);
    }
}

