/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOperations
implements GenericFileOperations<File> {
    private static final transient Log LOG = LogFactory.getLog(FileOperations.class);
    private FileEndpoint endpoint;

    public FileOperations() {
    }

    public FileOperations(FileEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setEndpoint(GenericFileEndpoint<File> endpoint) {
        this.endpoint = (FileEndpoint)endpoint;
    }

    @Override
    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        File file = new File(name);
        return FileUtil.deleteFile(file);
    }

    @Override
    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        File file = new File(from);
        File target = new File(to);
        return FileUtil.renameFile(file, target);
    }

    @Override
    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        File file = new File(name);
        return file.exists();
    }

    @Override
    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        String afterRoot;
        ObjectHelper.notNull(this.endpoint, "endpoint");
        if (this.endpoint.isAutoCreate() && !this.endpoint.getFile().exists()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Building starting directory: " + this.endpoint.getFile()));
            }
            this.endpoint.getFile().mkdirs();
        }
        if (ObjectHelper.isEmpty(directory)) {
            return true;
        }
        File endpointPath = this.endpoint.getFile();
        File target = new File(directory);
        File path = absolute ? target : (endpointPath.equals(target) ? endpointPath : (ObjectHelper.isNotEmpty(afterRoot = ObjectHelper.after(directory, endpointPath.getPath() + File.separator)) ? new File(this.endpoint.getFile(), afterRoot) : new File(this.endpoint.getFile(), directory)));
        if (path.isDirectory() && path.exists()) {
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Building directory: " + path));
        }
        return path.mkdirs();
    }

    @Override
    public List<File> listFiles() throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public List<File> listFiles(String path) throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
    }

    @Override
    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        return null;
    }

    @Override
    public boolean retrieveFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        return true;
    }

    @Override
    public boolean storeFile(String fileName, Exchange exchange) throws GenericFileOperationFailedException {
        ObjectHelper.notNull(this.endpoint, "endpoint");
        File file = new File(fileName);
        if (file.exists()) {
            if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An existing file already exists: " + file + ". Ignore and do not override it."));
                }
                return true;
            }
            if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + file + ". Cannot write new file.");
            }
        }
        try {
            File source = null;
            if (exchange.getIn().getBody() instanceof File || exchange.getIn().getBody() instanceof GenericFile) {
                source = exchange.getIn().getBody(File.class);
            }
            if (source != null) {
                File local = exchange.getIn().getHeader("CamelFileLocalWorkPath", File.class);
                if (local != null && local.exists()) {
                    boolean renamed = this.writeFileByLocalWorkPath(local, file);
                    if (renamed) {
                        this.keepLastModified(exchange, file);
                        exchange.getIn().setHeader("CamelFileLocalWorkPath", null);
                        return true;
                    }
                } else if (source.exists()) {
                    this.writeFileByFile(source, file);
                    this.keepLastModified(exchange, file);
                    return true;
                }
            }
            InputStream in = ExchangeHelper.getMandatoryInBody(exchange, InputStream.class);
            this.writeFileByStream(in, file);
            this.keepLastModified(exchange, file);
            return true;
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
        }
        catch (InvalidPayloadException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + file, e);
        }
    }

    private void keepLastModified(Exchange exchange, File file) {
        Date date;
        Long last;
        if (this.endpoint.isKeepLastModified() && (last = (date = exchange.getIn().getHeader("CamelFileLastModified", Date.class)) != null ? Long.valueOf(date.getTime()) : exchange.getIn().getHeader("CamelFileLastModified", Long.class)) != null) {
            boolean result = file.setLastModified(last);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Keeping last modified timestamp: " + last + " on file: " + file + " with result: " + result));
            }
        }
    }

    private boolean writeFileByLocalWorkPath(File source, File file) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Using local work file being renamed from: " + source + " to: " + file));
        }
        return FileUtil.renameFile(source, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByFile(File source, File target) throws IOException {
        FileChannel in = new FileInputStream(source).getChannel();
        FileChannel out = null;
        try {
            out = this.prepareOutputFileChannel(target, out);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using FileChannel to transfer from: " + in + " to: " + out));
            }
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, this.endpoint.getBufferSize(), out)) {
            }
        }
        finally {
            IOHelper.close(in, source.getName(), LOG);
            IOHelper.close(out, source.getName(), LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileByStream(InputStream in, File target) throws IOException {
        FileChannel out = null;
        try {
            int bytesRead;
            out = this.prepareOutputFileChannel(target, out);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using InputStream to transfer from: " + in + " to: " + out));
            }
            int size = this.endpoint.getBufferSize();
            byte[] buffer = new byte[size];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            while ((bytesRead = in.read(buffer)) != -1) {
                if (bytesRead < size) {
                    byteBuffer.limit(bytesRead);
                }
                out.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        finally {
            IOHelper.close(in, target.getName(), LOG);
            IOHelper.close(out, target.getName(), LOG);
        }
    }

    private FileChannel prepareOutputFileChannel(File target, FileChannel out) throws IOException {
        if (this.endpoint.getFileExist() == GenericFileExist.Append) {
            out = new RandomAccessFile(target, "rw").getChannel();
            out = out.position(out.size());
        } else {
            out = new FileOutputStream(target).getChannel();
        }
        return out;
    }
}

