/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module.sequence;

import fi.csc.microarray.client.LinkUtil;
import fi.csc.microarray.client.QuickLinkPanel;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.CreateFromTextDialog;
import fi.csc.microarray.client.dialog.SequenceImportDialog;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.selection.IntegratedEntity;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.basic.BasicModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jdesktop.swingx.JXHyperlink;

public class SequenceModule
implements Module {
    private static final String CATEGORY_PART_SEPARATOR = ":";
    private static final String EXAMPLE_SESSION_URL = "http://chipster.csc.fi/examples/embster.cs";

    @Override
    public void plugContentTypes(DataManager manager) {
        manager.plugContentType("chemical/x-fasta", true, false, "FASTA", VisualConstants.ICON_TYPE_TEXT, "fasta", "fa", "fna", "fsa", "mpfa");
        manager.plugContentType("text/wig", true, false, "WIG", VisualConstants.ICON_TYPE_TEXT, "wig");
        manager.plugContentType("text/bed", true, false, "BED", VisualConstants.ICON_TYPE_TEXT, "bed");
    }

    @Override
    public void plugFeatures(DataManager manager) {
    }

    @Override
    public void plugModifiers(DataManager manager) {
    }

    @Override
    public void plugTypeTags(DataManager manager) {
    }

    @Override
    public String[] getServerModuleNames() {
        return new String[]{"sequence"};
    }

    @Override
    public String getModuleLongName(String moduleName) {
        return "Sequence analysis";
    }

    @Override
    public void addImportMenuItems(JMenu importMenu) {
        importMenu.add(this.getImportSequenceMenuItem());
        importMenu.addSeparator();
        importMenu.add(this.getCreateFromTextMenuItem());
    }

    private JMenuItem getImportSequenceMenuItem() {
        JMenuItem importSequenceMenuItem = new JMenuItem();
        importSequenceMenuItem.setText("Database...");
        importSequenceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceModule.this.doImportSequence();
            }
        });
        return importSequenceMenuItem;
    }

    private JMenuItem getCreateFromTextMenuItem() {
        JMenuItem createFromTextMenuItem = new JMenuItem();
        createFromTextMenuItem.setText("Text...");
        createFromTextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceModule.this.doCreateFromText();
            }
        });
        return createFromTextMenuItem;
    }

    @Override
    public void addImportLinks(QuickLinkPanel quickLinkPanel, List<JXHyperlink> importLinks) {
        importLinks.add(LinkUtil.createLink("Import from UniProt, EMBL, PDB... ", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceModule.this.doImportSequence();
            }
        }));
        importLinks.add(LinkUtil.createLink("Create dataset from text ", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceModule.this.doCreateFromText();
            }
        }));
    }

    private void doCreateFromText() {
        try {
            new CreateFromTextDialog(Session.getSession().getApplication());
        }
        catch (Exception me) {
            Session.getSession().getApplication().reportException(me);
        }
    }

    private void doImportSequence() {
        try {
            new SequenceImportDialog(Session.getSession().getApplication());
        }
        catch (Exception me) {
            Session.getSession().getApplication().reportException(me);
        }
    }

    @Override
    public boolean isImportToolSupported() {
        return false;
    }

    @Override
    public boolean isWorkflowCompatible(DataBean data) {
        return true;
    }

    @Override
    public VisualisationMethod[] getVisualisationMethods() {
        return new VisualisationMethod[0];
    }

    @Override
    public URL[] getExampleSessionUrls(boolean isStandalone) throws MalformedURLException {
        return new URL[]{new URL(EXAMPLE_SESSION_URL)};
    }

    @Override
    public String[][] getRepositoryWorkflows() {
        return new String[0][0];
    }

    @Override
    public boolean isMetadata(DataBean data) {
        return false;
    }

    @Override
    public void postProcessOutputMetadata(Operation operation, DataBean metadataOutput) throws MicroarrayException, IOException {
    }

    @Override
    public String getShortDataName(String categoryName) {
        return BasicModule.shortenDataName(categoryName);
    }

    @Override
    public JPanel getContextLinkPanel(int selectedDataCount) {
        return null;
    }

    @Override
    public boolean notesVisibleAtStartup() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Embster";
    }

    @Override
    public String getManualHome() {
        return "http://chipster.csc.fi/embster/manual";
    }

    @Override
    public void addSpeadsheetMenuItems(JPopupMenu spreadsheetPopupMenu, VisualisationFrame visualisationFrame) {
    }

    @Override
    public List<Boolean> flagLinkableColumns(Table columns, DataBean data) {
        return Collections.nCopies(columns.getColumnCount(), false);
    }

    @Override
    public IntegratedEntity createLinkableEntity(Table columns, DataBean data) {
        return null;
    }
}

