/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.hc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.plot.HCTreeNodeInfo;

public class OrderSuperviser {
    HCPlot hcPlot;
    private List<String> treeToId = new ArrayList<String>();
    private List<Integer> treeToBean = new ArrayList<Integer>();
    private List<Integer> treeToVisible = new ArrayList<Integer>();

    public void setPlot(HCPlot hcPlot) {
        this.hcPlot = hcPlot;
    }

    public void setTreeToId(List<String> treeToId) {
        this.treeToId = treeToId;
    }

    public void setTreeToBean(List<Integer> treeToBean) {
        this.treeToBean = treeToBean;
    }

    public void setTreeToVisible(List<Integer> treeToVisible) {
        this.treeToVisible = treeToVisible;
    }

    public int idToTree(String id) {
        return this.treeToId.indexOf(id);
    }

    public int treeToVisible(int tree) {
        return this.treeToVisible.get(tree);
    }

    public List<Integer> visibleToTree(int visibleToFind) {
        ArrayList<Integer> treeIndexes = new ArrayList<Integer>();
        int tree = 0;
        for (int visible : this.treeToVisible) {
            if (visible == visibleToFind) {
                treeIndexes.add(tree);
            }
            ++tree;
        }
        return treeIndexes;
    }

    public int treeToBean(int tree) {
        return this.treeToBean.get(tree);
    }

    public int beanToTree(int bean) {
        return this.treeToBean.indexOf(bean);
    }

    public List<Integer> visibleToBean(Integer index) {
        ArrayList<Integer> beanIndexes = new ArrayList<Integer>();
        for (int tree : this.visibleToTree(index)) {
            beanIndexes.add(this.treeToBean(tree));
        }
        return beanIndexes;
    }

    public Integer beanToVisible(Integer bean) {
        return this.treeToVisible(this.beanToTree(bean));
    }

    public void updateVisibleIndexes() {
        ArrayList<Integer> treeToVisible = new ArrayList<Integer>();
        boolean openRoot = this.hcPlot.getRowClusteringInfo().getRootNode().isNodeOpen();
        this.updateVisibleIndexesSubTree(this.hcPlot.getRowClusteringInfo().getRootNode(), treeToVisible, openRoot, false);
        this.setTreeToVisible(treeToVisible);
    }

    private boolean updateVisibleIndexesSubTree(HCTreeNodeInfo node, List<Integer> list, boolean openSubTree, boolean firstLeafOfClosed) {
        if (node.getLeftChild() == null && node.getRightChild() == null) {
            if (list.size() == 0) {
                list.add(0);
                if (!openSubTree) {
                    firstLeafOfClosed = false;
                }
            } else if (openSubTree || firstLeafOfClosed) {
                firstLeafOfClosed = false;
                list.add(list.get(list.size() - 1) + 1);
            } else {
                list.add(list.get(list.size() - 1));
            }
        } else if (openSubTree && !node.isNodeOpen()) {
            this.updateVisibleIndexesSubTree(node, list, false, true);
        } else {
            if (node.getLeftChild() != null) {
                firstLeafOfClosed = this.updateVisibleIndexesSubTree(node.getLeftChild(), list, openSubTree, firstLeafOfClosed);
            }
            if (node.getRightChild() != null) {
                firstLeafOfClosed = this.updateVisibleIndexesSubTree(node.getRightChild(), list, openSubTree, firstLeafOfClosed);
            }
        }
        return firstLeafOfClosed;
    }

    public int[] getCountOfVisibleReferences() {
        ArrayList<Integer> countOfVisibleReferences = new ArrayList<Integer>();
        countOfVisibleReferences.addAll(Collections.nCopies(this.treeToVisible.size(), 0));
        int maxVisible = 0;
        for (int visible : this.treeToVisible) {
            countOfVisibleReferences.set(visible, (Integer)countOfVisibleReferences.get(visible) + 1);
            if (visible <= maxVisible) continue;
            maxVisible = visible;
        }
        int[] countTable = new int[maxVisible + 1];
        for (int i = 0; i <= maxVisible; ++i) {
            countTable[i] = (Integer)countOfVisibleReferences.get(i);
        }
        return countTable;
    }
}

