/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TabixIntensityTrack
extends Track {
    private SortedSet<RegionContent> values = new TreeSet<RegionContent>();
    private long minBpLength;
    private long maxBpLength;
    private Color color;

    public TabixIntensityTrack(View view, DataSource file, Color c, long minBpLength, long maxBpLength) {
        super(view, file);
        this.color = c;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Iterator iterator = this.values.iterator();
        TreeMap<Integer, Integer> profileDerivate = new TreeMap<Integer, Integer>();
        while (iterator.hasNext()) {
            RegionContent regCont = (RegionContent)iterator.next();
            if (!regCont.region.intersects(this.getView().getBpRegion())) {
                iterator.remove();
                continue;
            }
            int startX = this.getView().bpToTrack(regCont.region.start);
            int endX = this.getView().bpToTrack(regCont.region.end);
            int height = (int)Math.min(Math.log(((Float)regCont.values.get((Object)ColumnType.VALUE)).floatValue()) / (double)regCont.region.getLength().longValue() * 1000.0, (double)this.getView().getStretchableTrackHeight());
            if (profileDerivate.get(startX) == null) {
                profileDerivate.put(startX, 0);
            }
            profileDerivate.put(startX, (Integer)profileDerivate.get(startX) + height);
            if (profileDerivate.get(endX) == null) {
                profileDerivate.put(endX, 0);
            }
            profileDerivate.put(endX, (Integer)profileDerivate.get(endX) - height);
        }
        Iterator profileIterator = profileDerivate.keySet().iterator();
        int lastX = -1;
        int lastY = 0;
        int lastDrawnX = -1;
        int lastDrawnY = -1;
        while (profileIterator.hasNext()) {
            Integer x = (Integer)profileIterator.next();
            Integer newY = lastY + (Integer)profileDerivate.get(x);
            if (lastX != -1 && x - lastX > 10) {
                if (lastDrawnX != -1) {
                    drawables.add(new LineDrawable(lastDrawnX, lastDrawnY, lastX, newY, this.color));
                }
                drawables.add(new LineDrawable(lastX, newY, x, newY, this.color));
                lastDrawnX = x;
                lastDrawnY = newY;
            }
            lastX = x;
            lastY = newY;
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (areaResult.getStatus().concise != this.isConcised() || content.values.get((Object)ColumnType.VALUE) == null || !(content.values.get((Object)ColumnType.VALUE) instanceof Float) || !content.region.intersects(this.getView().getBpRegion())) continue;
            this.values.add(content);
        }
        this.getView().redraw();
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return super.getHeight();
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return this.isVisible();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() < this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet());
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }
}

