/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.util.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class EnumParameter
extends Parameter {
    private static final Logger logger = Logger.getLogger(EnumParameter.class);
    private int minCount = 1;
    private int maxCount = 1;
    private SelectionOption[] options;
    private List<SelectionOption> selectedOptions = new LinkedList<SelectionOption>();

    public EnumParameter(String id, String displayName, String description, SelectionOption[] options, List<SelectionOption> defaultOptions, int minCount, int maxCount) throws IllegalArgumentException {
        super(id, displayName, description);
        if (options == null) {
            throw new IllegalArgumentException("Options array for a selection parameter " + displayName + " may not be null!");
        }
        if (options.length == 0) {
            throw new IllegalArgumentException("Options array for a selection parameter " + displayName + " may not be empty!");
        }
        this.options = options;
        if (!defaultOptions.isEmpty()) {
            HashSet<SelectionOption> opts = new HashSet<SelectionOption>(Arrays.asList(options));
            opts.retainAll(defaultOptions);
            if (opts.size() != defaultOptions.size()) {
                throw new IllegalArgumentException("Some given default options were incorrect!");
            }
            this.selectedOptions.addAll(defaultOptions);
        }
        this.setMinCount(minCount);
        this.setMaxCount(maxCount);
    }

    @Override
    public EnumParameter clone() {
        EnumParameter param = (EnumParameter)super.clone();
        param.selectedOptions = new LinkedList<SelectionOption>(this.selectedOptions);
        return param;
    }

    public EnumParameter(String id, String displayName, String description) {
        super(id, displayName, description);
        this.options = null;
    }

    public Object[] getOptions() {
        assert (this.options != null);
        return this.options;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMinCount(int newMinCount) {
        if (newMinCount > this.maxCount) {
            throw new IllegalArgumentException("New minimum value for " + this.getID() + " cannot exceed current maximum value.");
        }
        this.minCount = newMinCount;
    }

    public void setMaxCount(int newMaxCount) {
        if (newMaxCount < this.minCount) {
            throw new IllegalArgumentException("New maximum value for " + this.getID() + " cannot fall below current minimum value.");
        }
        this.maxCount = newMaxCount;
    }

    @Override
    public void setValue(Object newValue) {
        this.selectedOptions.clear();
        if (newValue instanceof List || newValue instanceof String[]) {
            List<String> checkedList = newValue instanceof List ? (List<String>)newValue : Arrays.asList((String[])newValue);
            for (SelectionOption option : this.options) {
                if (!checkedList.contains(option.getValue())) continue;
                this.selectedOptions.add(option);
                logger.debug((Object)("adding value " + option.getValue()));
            }
            return;
        }
        if (newValue instanceof SelectionOption || newValue instanceof String) {
            String optionValue = newValue instanceof SelectionOption ? ((SelectionOption)newValue).getValue() : (String)newValue;
            for (SelectionOption option : this.options) {
                if (!option.getValue().equals(optionValue)) continue;
                this.selectedOptions.add(option);
                logger.debug((Object)("new value is " + option.getValue()));
                return;
            }
        }
        throw new IllegalArgumentException("illegal value for parameter " + this.getID() + ": " + newValue.toString());
    }

    public void setSelectedOptions(List<SelectionOption> newOptions) {
        this.selectedOptions = newOptions;
    }

    public List<SelectionOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    @Override
    public Object getValue() {
        assert (this.options != null);
        LinkedList<String> selectedValues = new LinkedList<String>();
        for (SelectionOption selectedOption : this.selectedOptions) {
            selectedValues.add(selectedOption.getValue());
        }
        return Strings.delimit(selectedValues, ",");
    }

    public void setOptions(SelectionOption[] newOptions, List<SelectionOption> newDefaults) throws IllegalArgumentException {
        this.options = newOptions;
        this.setSelectedOptions(newDefaults);
    }

    @Override
    public boolean checkValidityOf(Object valueObject) {
        return valueObject instanceof SelectionOption;
    }

    @Override
    public String toString() {
        return this.getID() + ": " + this.getValue();
    }

    @Override
    public String getValueAsJava() {
        return "\"" + this.getValue() + "\"";
    }

    @Override
    public void parseValue(String stringValue) throws IllegalArgumentException {
        String[] stringValues = stringValue.split(",");
        this.setValue(stringValues);
    }

    @Override
    public String getValueAsString() {
        return (String)this.getValue();
    }

    public static class SelectionOption {
        private String name;
        private String value;

        public SelectionOption(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            if (this.name != null && !this.name.isEmpty()) {
                return this.name;
            }
            return this.value;
        }

        public static SelectionOption[] convertStrings(String[] titles, String[] values) {
            SelectionOption[] options = new SelectionOption[titles.length];
            for (int i = 0; i < titles.length; ++i) {
                options[i] = new SelectionOption(titles[i], values[i]);
            }
            return options;
        }
    }
}

