/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gelitext;

import java.io.File;
import java.io.IOException;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.gelitext.DiploidGenotype;
import org.broad.tribble.gelitext.GeliTextCodec;
import org.broad.tribble.gelitext.GeliTextFeature;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class GeliTextTest {
    public static final File testFile = new File("test/data/testGeliText.txt");
    public static Index index;
    private FeatureReader<GeliTextFeature> source;

    @BeforeSuite
    public void beforeTest() {
        index = IndexFactory.createLinearIndex(testFile, new GeliTextCodec());
        this.source = AbstractFeatureReader.getFeatureReader(testFile.getAbsolutePath(), (FeatureCodec)new GeliTextCodec(), index);
    }

    @Test
    public void testReadAllLines() {
        try {
            CloseableTribbleIterator<GeliTextFeature> iter = this.source.query("22", 14438070, 14592250);
            int count = 0;
            while (iter.hasNext()) {
                GeliTextFeature feat = (GeliTextFeature)iter.next();
                ++count;
            }
            Assert.assertEquals((int)count, (int)50);
        }
        catch (IOException e) {
            Assert.fail((String)"failed to generate iterator from feature source");
        }
    }

    @Test
    public void testGetSubRegion() {
        try {
            CloseableTribbleIterator<GeliTextFeature> iter = this.source.query("22", 14438070, 14539060);
            int count = 0;
            while (iter.hasNext()) {
                GeliTextFeature feat = (GeliTextFeature)iter.next();
                ++count;
            }
            Assert.assertEquals((int)count, (int)41);
        }
        catch (IOException e) {
            Assert.fail((String)"failed to generate iterator from feature source");
        }
    }

    @Test
    public void testFirstRecord() {
        try {
            CloseableTribbleIterator<GeliTextFeature> iter = this.source.query("22", 14438070, 14592250);
            boolean count = false;
            GeliTextFeature feat = (GeliTextFeature)iter.next();
            Assert.assertTrue((boolean)"22".equals(feat.getChr()));
            Assert.assertEquals((int)feat.getStart(), (int)14438070);
            Assert.assertEquals((char)'A', (char)feat.getRefBase());
            Assert.assertEquals((double)feat.getDepthOfCoverage(), (double)0.0, (double)1.0E-4);
            Assert.assertEquals((double)feat.getMaximumMappingQual(), (double)0.0, (double)1.0E-4);
            Assert.assertTrue((boolean)DiploidGenotype.GG.equals((Object)feat.getGenotype()));
            Assert.assertEquals((double)feat.getDepthOfCoverage(), (double)0.0, (double)1.0E-4);
            Assert.assertEquals((double)feat.getLODBestToReference(), (double)33.2618, (double)1.0E-4);
            Assert.assertEquals((double)feat.getLODBestToNext(), (double)33.2618, (double)1.0E-4);
            int x = 0;
            while (x < feat.getLikelihoods().length) {
                if (x == DiploidGenotype.GG.ordinal()) {
                    Assert.assertEquals((double)feat.getLikelihoods()[x], (double)33.2618, (double)1.0E-4);
                } else {
                    Assert.assertEquals((double)feat.getLikelihoods()[x], (double)0.0, (double)1.0E-4);
                }
                ++x;
            }
        }
        catch (IOException e) {
            Assert.fail((String)"failed to generate iterator from feature source");
        }
    }
}

