/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.requestor;

import java.util.concurrent.FutureTask;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsProducer;
import org.apache.camel.component.jms.requestor.FailedToProcessResponse;
import org.apache.camel.component.jms.requestor.ReplyHandler;
import org.apache.camel.component.jms.requestor.Requestor;
import org.apache.camel.util.TimeoutMap;
import org.apache.camel.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredRequestReplyMap {
    private static final transient Log LOG = LogFactory.getLog(DeferredRequestReplyMap.class);
    private Requestor requestor;
    private JmsProducer producer;
    private TimeoutMap<String, Object> deferredRequestMap;
    private TimeoutMap<String, Object> deferredReplyMap;

    public DeferredRequestReplyMap(Requestor requestor, JmsProducer producer, TimeoutMap<String, Object> deferredRequestMap, TimeoutMap<String, Object> deferredReplyMap) {
        this.requestor = requestor;
        this.producer = producer;
        this.deferredRequestMap = deferredRequestMap;
        this.deferredReplyMap = deferredReplyMap;
    }

    public long getRequestTimeout() {
        return this.producer.getRequestTimeout();
    }

    public DeferredMessageSentCallback createDeferredMessageSentCallback() {
        return new DeferredMessageSentCallback(this, this.getUuidGenerator(), (Object)this.requestor);
    }

    public void put(DeferredMessageSentCallback callback, FutureTask futureTask) {
        this.deferredRequestMap.put((Object)callback.getID(), (Object)futureTask, this.getRequestTimeout());
    }

    public void processDeferredRequests(String correlationID, Message inMessage) {
        DeferredRequestReplyMap.processDeferredRequests((Object)this.requestor, this.deferredRequestMap, this.deferredReplyMap, correlationID, this.requestor.getMaxRequestTimeout(), inMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processDeferredRequests(Object monitor, TimeoutMap<String, Object> requestMap, TimeoutMap<String, Object> replyMap, String correlationID, long timeout, Message inMessage) {
        Object object = monitor;
        synchronized (object) {
            try {
                ReplyHandler replyHandler;
                boolean complete;
                Object handler = requestMap.get((Object)correlationID);
                if (handler == null) {
                    if (requestMap.size() > replyMap.size()) {
                        replyMap.put((Object)correlationID, (Object)inMessage, timeout);
                    } else {
                        LOG.warn((Object)("Response received for unknown correlationID: " + correlationID + "; response: " + inMessage));
                    }
                }
                if (handler != null && handler instanceof ReplyHandler && (complete = (replyHandler = (ReplyHandler)handler).handle(inMessage))) {
                    requestMap.remove((Object)correlationID);
                }
            }
            catch (JMSException e) {
                throw new FailedToProcessResponse(inMessage, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDeferredReplies(Object monitor, String transitionalID, Message outMessage) {
        Object object = monitor;
        synchronized (object) {
            block10: {
                try {
                    Object handler = this.deferredRequestMap.get((Object)transitionalID);
                    if (handler == null) {
                        return;
                    }
                    this.deferredRequestMap.remove((Object)transitionalID);
                    String correlationID = outMessage.getJMSMessageID();
                    Object in = this.deferredReplyMap.get((Object)correlationID);
                    if (in != null && in instanceof Message) {
                        Message inMessage = (Message)in;
                        if (!(handler instanceof ReplyHandler)) break block10;
                        ReplyHandler replyHandler = (ReplyHandler)handler;
                        try {
                            boolean complete = replyHandler.handle(inMessage);
                            if (complete) {
                                this.deferredReplyMap.remove((Object)correlationID);
                            }
                            break block10;
                        }
                        catch (JMSException e) {
                            throw new FailedToProcessResponse(inMessage, e);
                        }
                    }
                    this.deferredRequestMap.put((Object)correlationID, handler, this.getRequestTimeout());
                }
                catch (JMSException e) {
                    throw new FailedToProcessResponse(outMessage, e);
                }
            }
        }
    }

    protected UuidGenerator getUuidGenerator() {
        return this.producer.getUuidGenerator();
    }

    public static class DeferredMessageSentCallback
    implements JmsConfiguration.MessageSentCallback {
        private DeferredRequestReplyMap map;
        private String transitionalID;
        private Message message;
        private Object monitor;

        public DeferredMessageSentCallback(DeferredRequestReplyMap map, UuidGenerator uuidGenerator, Object monitor) {
            this.transitionalID = uuidGenerator.generateUuid();
            this.map = map;
            this.monitor = monitor;
        }

        public DeferredRequestReplyMap getDeferredRequestReplyMap() {
            return this.map;
        }

        public String getID() {
            return this.transitionalID;
        }

        public Message getMessage() {
            return this.message;
        }

        public void sent(Message message) {
            this.message = message;
            this.map.processDeferredReplies(this.monitor, this.getID(), message);
        }
    }
}

