/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.soap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.emboss.jemboss.Jemboss;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.ShowSavedResults;
import org.emboss.jemboss.programs.JembossProcess;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.PrivateRequest;

public class PendingResults {
    private int completed_jobs = 0;
    private int running_jobs = 0;
    private JembossParams mysettings;
    private Vector pendingResults;
    private JButton jobButton = null;
    private JComboBox jobComboBox = null;
    private boolean autoUpdates = false;

    public PendingResults(JembossParams jembossParams) {
        this.mysettings = jembossParams;
        this.pendingResults = new Vector();
    }

    public void addRunningJob() {
        ++this.running_jobs;
        if (this.jobButton != null) {
            this.jobButton.setText(this.jobStatus());
        }
    }

    public void deleteRunningJob() {
        --this.running_jobs;
        ++this.completed_jobs;
        if (this.jobButton != null) {
            this.jobButton.setText(this.jobStatus());
        }
    }

    public void resetCount() {
        this.completed_jobs = 0;
        this.running_jobs = 0;
        this.pendingResults.removeAllElements();
    }

    public void addResult(JembossProcess jembossProcess) {
        this.pendingResults.add(jembossProcess);
    }

    public void removeResult(JembossProcess jembossProcess) {
        this.pendingResults.remove(jembossProcess);
    }

    public JembossProcess getResult(String string) {
        for (int i = 0; i < this.pendingResults.size(); ++i) {
            JembossProcess jembossProcess = (JembossProcess)this.pendingResults.get(i);
            if (!jembossProcess.getJob().equals(string)) continue;
            return jembossProcess;
        }
        return null;
    }

    public Hashtable descriptionHash() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < this.pendingResults.size(); ++i) {
            JembossProcess jembossProcess = (JembossProcess)this.pendingResults.get(i);
            String string = jembossProcess.getDescription();
            if (string == null || string.equals("")) {
                string = " Pending";
            }
            hashtable.put(jembossProcess.getJob(), string);
        }
        return hashtable;
    }

    public void updateJobStats() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.pendingResults.size(); ++i) {
            JembossProcess jembossProcess = (JembossProcess)this.pendingResults.get(i);
            if (jembossProcess.isCompleted()) {
                ++n;
            }
            if (!jembossProcess.isRunning()) continue;
            ++n2;
        }
        this.completed_jobs = n;
        this.running_jobs = n2;
    }

    public String jobStatus() {
        String string = new Integer(this.completed_jobs).toString();
        String string2 = new Integer(this.running_jobs).toString();
        String string3 = this.completed_jobs == 0 ? (this.running_jobs == 0 ? "Jobs: no pending jobs" : "Jobs: " + string2 + " running") : (this.running_jobs == 0 ? "Jobs: " + string + " completed" : "Jobs: " + string + " completed / " + string2 + " running");
        return string3;
    }

    public void updateStatus() {
        Vector<Object> vector = new Vector<Object>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < this.pendingResults.size(); ++i) {
            JembossProcess jembossProcess = (JembossProcess)this.pendingResults.get(i);
            hashtable.put(jembossProcess.getJob(), jembossProcess.getProject());
        }
        vector.addElement("");
        vector.addElement("");
        vector.addElement(this.getVector(hashtable));
        try {
            PrivateRequest privateRequest = new PrivateRequest(this.mysettings, "update_result_status", vector);
            for (int i = 0; i < this.pendingResults.size(); ++i) {
                JembossProcess jembossProcess = (JembossProcess)this.pendingResults.get(i);
                String string = jembossProcess.getJob();
                String string2 = (String)privateRequest.getVal(string);
                if (this.mysettings.getDebug()) {
                    System.out.println("PendingResults: " + string + " : " + string2);
                }
                if (!string2.equals("complete")) continue;
                jembossProcess.complete();
                String string3 = (String)privateRequest.getVal(string + "-description");
                if (string3.equals("")) continue;
                jembossProcess.setDescription(string3);
            }
            this.updateJobStats();
            if (this.jobButton != null) {
                this.jobButton.setText(this.jobStatus());
            }
        }
        catch (JembossSoapException jembossSoapException) {
            // empty catch block
        }
    }

    private Vector getVector(Hashtable hashtable) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.add(string);
            vector.add((String)hashtable.get(string));
        }
        return vector;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdates;
    }

    public void setAutoUpdate(boolean bl) {
        this.autoUpdates = bl;
    }

    public void updateMode() {
        if (this.jobComboBox != null) {
            this.jobComboBox.setSelectedItem(this.mysettings.getCurrentMode());
        }
    }

    public void updateMode(String string) {
        this.mysettings.setCurrentMode(string);
        if (this.jobComboBox != null) {
            this.jobComboBox.setSelectedItem(this.mysettings.getCurrentMode());
        }
    }

    public JPanel statusPanel(final JFrame jFrame) {
        final JPanel jPanel = new JPanel(new BorderLayout());
        ClassLoader classLoader = this.getClass().getClassLoader();
        ImageIcon imageIcon = new ImageIcon(classLoader.getResource("images/Job_manager_button.gif"));
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setToolTipText("Batch Job Manager");
        jPanel.add((Component)jLabel, "West");
        this.jobButton = new JButton("(No Current Jobs)");
        this.jobButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!Jemboss.withSoap) {
                    return;
                }
                jPanel.setCursor(new Cursor(3));
                PendingResults.this.showPendingResults(jFrame);
                jPanel.setCursor(new Cursor(0));
            }
        });
        jPanel.add((Component)this.jobButton, "Center");
        this.jobComboBox = new JComboBox(this.mysettings.modeVector());
        this.updateMode();
        this.jobComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                PendingResults.this.mysettings.setCurrentMode(string);
            }
        });
        jPanel.add((Component)this.jobComboBox, "East");
        Dimension dimension = jPanel.getPreferredSize();
        dimension = new Dimension((int)dimension.getWidth(), imageIcon.getIconHeight() - 2);
        jPanel.setPreferredSize(dimension);
        return jPanel;
    }

    public void showPendingResults(JFrame jFrame) {
        if (this.completed_jobs == 0 && this.running_jobs == 0) {
            JOptionPane.showMessageDialog(jFrame, "You can only view pending results\nif batch/background jobs have been\nsubmitted in the current session.");
        } else {
            try {
                new ShowSavedResults(this.mysettings, this);
            }
            catch (JembossSoapException jembossSoapException) {
                new AuthPopup(this.mysettings, jFrame);
            }
        }
    }

    public String getStatus() {
        return this.jobButton.getText();
    }
}

