/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.description.SADLGenerator;
import fi.csc.microarray.description.SADLSyntax;
import java.util.LinkedList;
import java.util.List;

public class SADLDescription {
    private Name name;
    private String comment;
    private LinkedList<Input> inputs = new LinkedList();
    private LinkedList<Output> outputs = new LinkedList();
    private LinkedList<Parameter> parameters = new LinkedList();

    public SADLDescription(Name name) {
        this(name, null);
    }

    public SADLDescription(Name name, String comment) {
        this.name = name;
        this.comment = comment;
    }

    public void addInput(Input input) {
        this.inputs.add(input);
    }

    public void addOutput(Output metaOutput) {
        this.outputs.add(metaOutput);
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public Name getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public void addInputs(List<Input> inputCollection) {
        this.inputs.addAll(inputCollection);
    }

    public void addOutputs(List<Output> outputCollection) {
        this.outputs.addAll(outputCollection);
    }

    public String toString() {
        return SADLGenerator.generate(this);
    }

    public void setID(String id) {
        this.name.setID(id);
    }

    public static class Parameter
    extends Entity {
        private SADLSyntax.ParameterType type;
        private Name[] selectionOptions;
        private String from;
        private String to;
        private String[] defaultValues;

        public Parameter(Name name, SADLSyntax.ParameterType type, Name[] selectionOptions, String from, String to, String defaultValue) {
            this(name, type, selectionOptions, from, to, defaultValue, null);
        }

        public Parameter(Name name, SADLSyntax.ParameterType type, Name[] selectionOptions, String from, String to, String defaultValue, String comment) {
            String[] stringArray;
            if (defaultValue == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultValue;
            }
            this(name, type, selectionOptions, from, to, stringArray, comment);
        }

        public Parameter(Name name, SADLSyntax.ParameterType type, Name[] selectionOptions, String from, String to, String[] defaultValues) {
            this(name, type, selectionOptions, from, to, defaultValues, null);
        }

        public Parameter(Name name, SADLSyntax.ParameterType type, Name[] selectionOptions, String from, String to, String[] defaultValues, String comment) {
            super(name, false);
            this.type = type;
            this.selectionOptions = selectionOptions;
            this.from = from;
            this.to = to;
            this.defaultValues = defaultValues;
            this.comment = comment;
        }

        public SADLSyntax.ParameterType getType() {
            return this.type;
        }

        public Name[] getSelectionOptions() {
            return this.selectionOptions;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getDefaultValue() {
            if (this.defaultValues.length != 1) {
                throw new IllegalStateException("there needs to be 1 default value, not " + this.defaultValues.length);
            }
            return this.defaultValues[0];
        }

        public String[] getDefaultValues() {
            return this.defaultValues;
        }
    }

    public static class Output
    extends IOEntity {
        public Output() {
            this(Name.createEmptyName());
        }

        public Output(Name name) {
            this(name, false);
        }

        public Output(Name name, boolean optional) {
            this(name, optional, false);
        }

        public Output(Name name, boolean optional, boolean isMeta) {
            super(name, optional, isMeta);
        }
    }

    public static class Input
    extends IOEntity {
        private SADLSyntax.InputType type;

        public Input() {
            this(null, Name.createEmptyName(), false);
        }

        public Input(SADLSyntax.InputType type, Name name) {
            this(type, name, false);
        }

        public Input(SADLSyntax.InputType type, Name name, boolean optional) {
            this(type, name, optional, false);
        }

        public Input(SADLSyntax.InputType type, Name name, boolean optional, boolean isMeta) {
            super(name, optional, isMeta);
            this.type = type;
        }

        public void setType(SADLSyntax.InputType type) {
            this.type = type;
        }

        public SADLSyntax.InputType getType() {
            return this.type;
        }
    }

    public static class IOEntity
    extends Entity {
        private boolean isMeta;

        public IOEntity(Name name, boolean isOptional, boolean isMeta) {
            super(name, isOptional);
            this.isMeta = isMeta;
        }

        public boolean isMeta() {
            return this.isMeta;
        }

        public void setMeta(boolean isMeta) {
            this.isMeta = isMeta;
        }
    }

    public static class Entity {
        private Name name;
        private boolean isOptional;
        protected String comment;

        public Entity(Name name, boolean isOptional) {
            this.name = name;
            this.isOptional = isOptional;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public void setOptional(boolean isOptional) {
            this.isOptional = isOptional;
        }

        public void setName(Name name) {
            this.name = name;
        }

        public Name getName() {
            return this.name;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }
    }

    public static class Name {
        private String id = null;
        private String displayName = null;
        private String prefix;
        private String postfix;

        public static Name createEmptyName() {
            return new Name(null, null, null, null);
        }

        public static Name createName(String name, String displayName) {
            return new Name(name, null, null, displayName);
        }

        public static Name createName(String name) {
            return new Name(name, null, null, name);
        }

        public static Name createNameSet(String prefix, String postfix, String displayName) {
            return new Name(null, prefix, postfix, displayName);
        }

        public static Name createNameSet(String prefix, String postfix) {
            return new Name(null, prefix, postfix, prefix + "{...}" + postfix);
        }

        private Name(String id, String prefix, String postfix, String displayName) {
            this.id = id;
            this.prefix = prefix;
            this.postfix = postfix;
            this.displayName = displayName;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setPostfix(String postfix) {
            this.postfix = postfix;
        }

        public String getID() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public boolean isSpliced() {
            return this.getPrefix() != null || this.getPostfix() != null;
        }

        public boolean isNameSet() {
            return this.id == null;
        }

        public String toString() {
            return SADLGenerator.generateName(this);
        }
    }
}

