/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Exon;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Gene;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import java.util.Collection;
import java.util.TreeSet;

public class Transcript
extends TreeSet<Exon>
implements Comparable<Transcript> {
    private Gene gene;
    private Region region;
    private String name;
    private String id;

    public Transcript(String name, Gene gene, String id) {
        this.name = name;
        this.gene = gene;
        this.id = id;
    }

    @Override
    public int compareTo(Transcript other) {
        return this.id.compareTo(other.id);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Transcript) {
            return this.compareTo((Transcript)o) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.region.toString(true) + ", " + this.name;
    }

    public Region getRegion() {
        return this.region;
    }

    public void addExon(Exon exon, String transcId) {
        this.add(exon);
        if (this.region == null) {
            try {
                this.region = exon.getRegion().clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        } else {
            this.region = this.region.fill(exon.getRegion());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Collection<Exon> getExons() {
        return this;
    }
}

